/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroupKt;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002BS\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\n\u00100\u001a\u0004\u0018\u00010\u0019H\u0016J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u00101\u001a\u000202J\n\u00103\u001a\u0004\u0018\u00010\nH\u0016J\b\u00104\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00065"}, d2={"Lorg/jetbrains/debugger/frame/CallFrameView;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "Lorg/jetbrains/debugger/VariableContext;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "script", "Lorg/jetbrains/debugger/Script;", "sourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "isInLibraryContent", "", "vm", "Lorg/jetbrains/debugger/Vm;", "methodReturnValue", "Lorg/jetbrains/debugger/Variable;", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;Ljava/lang/Boolean;Lorg/jetbrains/debugger/Vm;Lorg/jetbrains/debugger/Variable;)V", "getCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluateContext", "()Lorg/jetbrains/debugger/EvaluateContext;", "evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "memberFilter", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "getMemberFilter", "()Lorg/jetbrains/concurrency/Promise;", "getMethodReturnValue", "()Lorg/jetbrains/debugger/Variable;", "getScript", "()Lorg/jetbrains/debugger/Script;", "getViewSupport", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getEqualityObject", "", "getEvaluator", "scope", "Lorg/jetbrains/debugger/Scope;", "getSourcePosition", "watchableAsEvaluationExpression", "intellij.javascript.debugger.ui"})
public final class CallFrameView
extends XStackFrame
implements VariableContext {
    @NotNull
    private final CallFrame callFrame;
    @NotNull
    private final DebuggerViewSupport viewSupport;
    @Nullable
    private final Script script;
    @Nullable
    private final Vm vm;
    @Nullable
    private final Variable methodReturnValue;
    @Nullable
    private final SourceInfo sourceInfo;
    private final boolean isInLibraryContent;
    @Nullable
    private XDebuggerEvaluator evaluator;

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo, @Nullable Boolean isInLibraryContent, @Nullable Vm vm, @Nullable Variable methodReturnValue) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        this.callFrame = callFrame;
        this.viewSupport = viewSupport;
        this.script = script;
        this.vm = vm;
        this.methodReturnValue = methodReturnValue;
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 == null) {
            sourceInfo2 = this.getViewSupport().getSourceInfo(this.script, this.callFrame);
        }
        this.sourceInfo = sourceInfo2;
        Boolean bl = isInLibraryContent;
        this.isInLibraryContent = bl != null ? bl : this.sourceInfo != null && this.getViewSupport().isInLibraryContent(this.sourceInfo, this.script);
    }

    public /* synthetic */ CallFrameView(CallFrame callFrame, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, Boolean bl, Vm vm, Variable variable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            script = null;
        }
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        if ((n & 0x20) != 0) {
            vm = null;
        }
        if ((n & 0x40) != 0) {
            variable = null;
        }
        this(callFrame, debuggerViewSupport, script, sourceInfo, bl, vm, variable);
    }

    @NotNull
    public final CallFrame getCallFrame() {
        return this.callFrame;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.viewSupport;
    }

    @Nullable
    public final Script getScript() {
        return this.script;
    }

    @Override
    @Nullable
    public Vm getVm() {
        return this.vm;
    }

    @Nullable
    public final Variable getMethodReturnValue() {
        return this.methodReturnValue;
    }

    @NotNull
    public Object getEqualityObject() {
        return this.callFrame.getEqualityObject();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.setAlreadySorted(true);
        Variable variable = this.methodReturnValue;
        if (variable != null) {
            Variable it = variable;
            boolean bl = false;
            XValueChildrenList list = XValueChildrenList.singleton((XNamedValue)VariableViewKt.VariableView(this.methodReturnValue, this));
            node.addChildren(list, false);
        }
        ScopeVariablesGroupKt.createAndAddScopeList(node, this.callFrame.getVariableScopes(), this, this.callFrame);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.callFrame.getEvaluateContext();
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return true;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.getViewSupport().getMemberFilter(this);
    }

    @NotNull
    public final Promise<MemberFilter> getMemberFilter(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ScopeVariablesGroupKt.createVariableContext(scope, this, this.callFrame).getMemberFilter();
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.getViewSupport().createFrameEvaluator(this);
        }
        return this.evaluator;
    }

    @Nullable
    public SourceInfo getSourcePosition() {
        return this.sourceInfo;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.sourceInfo == null) {
            String scriptName = this.script == null ? XDebuggerBundle.message((String)"stack.frame.function.unknown", (Object[])new Object[0]) : this.script.getUrl().trimParameters().toDecodedForm();
            int line = this.callFrame.getLine();
            component.append((String)(line == -1 ? scriptName : scriptName + ":" + line), SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        String string = this.sourceInfo.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        int line = this.sourceInfo.getLine() + 1;
        SimpleTextAttributes textAttributes = this.isInLibraryContent || this.callFrame.isFromAsyncStack() ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        String functionName = this.sourceInfo.getFunctionName();
        if (functionName == null || ((CharSequence)functionName).length() == 0 && this.callFrame.getHasOnlyGlobalScope()) {
            if (StringsKt.startsWith$default((String)fileName, (String)"index.", (boolean)false, (int)2, null)) {
                VirtualFile virtualFile = this.sourceInfo.getFile().getParent();
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    component.append(it.getName() + "/", textAttributes);
                }
            }
            component.append(fileName + ":" + line, textAttributes);
        } else {
            if (((CharSequence)functionName).length() == 0) {
                component.append(XDebuggerBundle.message((String)"stack.frame.function.name.anonymous", (Object[])new Object[0]), this.isInLibraryContent ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                component.append(functionName, textAttributes);
            }
            component.append("(), " + fileName + ":" + line, textAttributes);
        }
        component.setIcon(AllIcons.Debugger.Frame);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo, @Nullable Boolean isInLibraryContent, @Nullable Vm vm) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        this(callFrame, viewSupport, script, sourceInfo, isInLibraryContent, vm, null, 64, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo, @Nullable Boolean isInLibraryContent) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        this(callFrame, viewSupport, script, sourceInfo, isInLibraryContent, null, null, 96, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        this(callFrame, viewSupport, script, sourceInfo, null, null, null, 112, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        this(callFrame, viewSupport, script, null, null, null, null, 120, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        this(callFrame, viewSupport, null, null, null, null, null, 124, null);
    }
}

