/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExecutionStackView;
import org.jetbrains.debugger.InactiveAtBreakpointExecutionStackView;
import org.jetbrains.debugger.MultiVmDebugProcess;
import org.jetbrains.debugger.RunningThreadExecutionStackView;
import org.jetbrains.debugger.ScriptExecutionStack;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0014J+\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00140\u00140\u0013\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0016J\u0015\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010&\u001a\u00020\"J\u0010\u0010'\u001a\u00020 2\b\u0010(\u001a\u0004\u0018\u00010)R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/debugger/SuspendContextView;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "debugProcess", "Lorg/jetbrains/debugger/MultiVmDebugProcess;", "activeStack", "Lorg/jetbrains/debugger/ExecutionStackView;", "activeVm", "Lorg/jetbrains/debugger/Vm;", "(Lorg/jetbrains/debugger/MultiVmDebugProcess;Lorg/jetbrains/debugger/ExecutionStackView;Lorg/jetbrains/debugger/Vm;)V", "getActiveVm", "()Lorg/jetbrains/debugger/Vm;", "setActiveVm", "(Lorg/jetbrains/debugger/Vm;)V", "getDebugProcess", "()Lorg/jetbrains/debugger/MultiVmDebugProcess;", "stacks", "", "Lorg/jetbrains/debugger/ScriptExecutionStack;", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "", "expression", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack", "getExecutionStacks", "", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "()[Lcom/intellij/xdebugger/frame/XExecutionStack;", "hasPausedThreads", "", "pauseInactiveThread", "", "inactiveThread", "resume", "vm", "resumeCurrentThread", "setActiveThread", "selectedStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "intellij.javascript.debugger.ui"})
@SourceDebugExtension(value={"SMAP\nSuspendContextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendContextView.kt\norg/jetbrains/debugger/SuspendContextView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,230:1\n1855#2:231\n1856#2:233\n1747#2,3:236\n1855#2,2:239\n13#3:232\n37#4,2:234\n*S KotlinDebug\n*F\n+ 1 SuspendContextView.kt\norg/jetbrains/debugger/SuspendContextView\n*L\n45#1:231\n45#1:233\n93#1:236,3\n123#1:239,2\n54#1:232\n68#1:234,2\n*E\n"})
public abstract class SuspendContextView
extends XSuspendContext {
    @NotNull
    private final MultiVmDebugProcess debugProcess;
    @NotNull
    private volatile Vm activeVm;
    @NotNull
    private final Map<Vm, ScriptExecutionStack> stacks;

    public SuspendContextView(@NotNull MultiVmDebugProcess debugProcess, @NotNull ExecutionStackView activeStack, @NotNull Vm activeVm) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)activeStack), (String)"activeStack");
        Intrinsics.checkNotNullParameter((Object)activeVm, (String)"activeVm");
        this.debugProcess = debugProcess;
        this.activeVm = activeVm;
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.stacks = map;
        Vm mainVm = this.debugProcess.getMainVm();
        List<Vm> vmList = this.debugProcess.getCollectVMs();
        if (mainVm != null && !vmList.isEmpty()) {
            Iterable $this$forEach$iv = vmList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScriptExecutionStack scriptExecutionStack;
                Vm it = (Vm)element$iv;
                boolean bl = false;
                SuspendContext suspendContext = it.getSuspendContextManager().getContext();
                if (suspendContext == null) {
                    scriptExecutionStack = new RunningThreadExecutionStackView(it);
                } else if (Intrinsics.areEqual((Object)suspendContext, activeStack.getSuspendContext())) {
                    scriptExecutionStack = activeStack;
                } else {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(SuspendContextView.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Paused VM was lost.");
                    scriptExecutionStack = new InactiveAtBreakpointExecutionStackView(it);
                }
                ScriptExecutionStack stack = scriptExecutionStack;
                this.stacks.put(it, stack);
            }
        } else {
            this.stacks.put(this.activeVm, activeStack);
        }
    }

    @NotNull
    protected final MultiVmDebugProcess getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final Vm getActiveVm() {
        return this.activeVm;
    }

    public final void setActiveVm(@NotNull Vm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"<set-?>");
        this.activeVm = vm;
    }

    @Nullable
    public ScriptExecutionStack getActiveExecutionStack() {
        return this.stacks.get(this.activeVm);
    }

    @NotNull
    public XExecutionStack[] getExecutionStacks() {
        Collection<ScriptExecutionStack> $this$toTypedArray$iv = this.stacks.values();
        boolean $i$f$toTypedArray = false;
        Collection<ScriptExecutionStack> thisCollection$iv = $this$toTypedArray$iv;
        return (XExecutionStack[])thisCollection$iv.toArray(new ScriptExecutionStack[0]);
    }

    @NotNull
    public final Promise<String> evaluateExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ScriptExecutionStack scriptExecutionStack = this.stacks.get(this.activeVm);
        Intrinsics.checkNotNull((Object)scriptExecutionStack);
        ScriptExecutionStack activeStack = scriptExecutionStack;
        XStackFrame xStackFrame = activeStack.getTopFrame();
        if (xStackFrame == null) {
            return Promises.rejectedPromise((String)"Top frame is null");
        }
        XStackFrame frame = xStackFrame;
        if (!(frame instanceof CallFrameView)) {
            return Promises.rejectedPromise((String)"Can't evaluate on non-paused thread");
        }
        return this.evaluateExpression(((CallFrameView)frame).getCallFrame().getEvaluateContext(), expression);
    }

    private final Promise<String> evaluateExpression(EvaluateContext evaluateContext, String expression) {
        Promise promise2 = EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)expression, null, (boolean)false, null, (int)14, null).thenAsync(arg_0 -> SuspendContextView.evaluateExpression$lambda$1(evaluateExpression.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    public final void pauseInactiveThread(@NotNull ExecutionStackView inactiveThread) {
        Intrinsics.checkNotNullParameter((Object)((Object)inactiveThread), (String)"inactiveThread");
        this.stacks.put(inactiveThread.getVm(), inactiveThread);
    }

    public final boolean hasPausedThreads() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.stacks.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScriptExecutionStack it = (ScriptExecutionStack)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ExecutionStackView)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void resume(@NotNull Vm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        ScriptExecutionStack prevStack = this.stacks.get(vm);
        if (prevStack instanceof ExecutionStackView) {
            this.stacks.put(vm, new RunningThreadExecutionStackView(((ExecutionStackView)prevStack).getVm()));
        }
    }

    public final void resumeCurrentThread() {
        this.resume(this.activeVm);
    }

    public final boolean setActiveThread(@Nullable XStackFrame selectedStackFrame) {
        if (!(selectedStackFrame instanceof CallFrameView)) {
            return false;
        }
        Vm selectedVm = null;
        for (Map.Entry<Vm, ScriptExecutionStack> entry : this.stacks.entrySet()) {
            Vm key = entry.getKey();
            ScriptExecutionStack value = entry.getValue();
            if (!(value instanceof ExecutionStackView)) continue;
            CallFrameView callFrameView = ((ExecutionStackView)value).getTopFrame();
            if (!Intrinsics.areEqual((Object)(callFrameView != null ? callFrameView.getVm() : null), (Object)((CallFrameView)selectedStackFrame).getVm())) continue;
            selectedVm = key;
            break;
        }
        ScriptExecutionStack selectedVmStack = this.stacks.get(selectedVm);
        if (selectedVm != null && selectedVmStack instanceof ExecutionStackView) {
            this.activeVm = selectedVm;
            this.stacks.put(selectedVm, ((ExecutionStackView)selectedVmStack).copyWithIsCurrent(true));
            Iterable $this$forEach$iv = this.stacks.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vm it = (Vm)element$iv;
                boolean bl = false;
                ScriptExecutionStack stack = this.stacks.get(it);
                if (Intrinsics.areEqual((Object)it, (Object)selectedVm) || !(stack instanceof ExecutionStackView)) continue;
                this.stacks.put(it, ((ExecutionStackView)stack).copyWithIsCurrent(false));
            }
            return this.stacks.get(selectedVm) != selectedVmStack;
        }
        return false;
    }

    private static final Promise evaluateExpression$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }
}

