/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Variable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0014J\u0010\u0010\u0002\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/debugger/MemberFilterWithNameMappings;", "Lorg/jetbrains/debugger/MemberFilter;", "rawNameToSource", "", "", "(Ljava/util/Map;)V", "hasNameMappings", "", "normalizeMemberName", "name", "variable", "Lorg/jetbrains/debugger/Variable;", "sourceNameToRaw", "intellij.javascript.debugger.ui"})
public class MemberFilterWithNameMappings
implements MemberFilter {
    @NotNull
    private final Map<String, String> rawNameToSource;

    public MemberFilterWithNameMappings(@NotNull Map<String, String> rawNameToSource) {
        Intrinsics.checkNotNullParameter(rawNameToSource, (String)"rawNameToSource");
        this.rawNameToSource = rawNameToSource;
    }

    public /* synthetic */ MemberFilterWithNameMappings(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @Override
    public boolean hasNameMappings() {
        return !this.rawNameToSource.isEmpty();
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        String sourceName = this.rawNameToSource.get(name);
        String string2 = sourceName;
        if (string2 == null) {
            string2 = this.normalizeMemberName(name);
        }
        return string2;
    }

    @NotNull
    protected String normalizeMemberName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return name;
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.hasNameMappings()) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.rawNameToSource.entrySet()) {
            String generatedName = entry.getKey();
            String sourceName = entry.getValue();
            if (!Intrinsics.areEqual((Object)sourceName, (Object)name)) continue;
            return generatedName;
        }
        return null;
    }

    public MemberFilterWithNameMappings() {
        this(null, 1, null);
    }
}

