/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030*2\u0006\u0010+\u001a\u00020,H&J\b\u0010-\u001a\u00020\u0007H\u0016J\u0015\u0010.\u001a\u00020/2\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u00100J\u0016\u00101\u001a\u00020/2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u000102J\f\u00103\u001a\u0006\u0012\u0002\b\u00030*H&R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00064"}, d2={"Lorg/jetbrains/debugger/BreakpointBase;", "L", "", "Lorg/jetbrains/debugger/Breakpoint;", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "enabled", "", "(Lorg/jetbrains/debugger/BreakpointTarget;IILjava/lang/String;Z)V", "actualLocations", "", "getActualLocations", "()Ljava/util/List;", "getColumn", "()I", "value", "getCondition", "()Ljava/lang/String;", "setCondition", "(Ljava/lang/String;)V", "dirty", "getDirty", "()Z", "setDirty", "(Z)V", "getEnabled", "setEnabled", "isResolved", "getLine", "setLine", "(I)V", "pendingRemove", "getPendingRemove", "setPendingRemove", "getTarget", "()Lorg/jetbrains/debugger/BreakpointTarget;", "flush", "Lorg/jetbrains/concurrency/Promise;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "hashCode", "setActualLocation", "", "(Ljava/lang/Object;)V", "setActualLocations", "", "vmRegistered", "intellij.javascript.debugger.backend"})
public abstract class BreakpointBase<L>
implements Breakpoint {
    @NotNull
    private final BreakpointTarget target;
    private int line;
    private final int column;
    @NotNull
    private final List<L> actualLocations;
    private volatile boolean dirty;
    private boolean pendingRemove;
    @Nullable
    private String condition;
    private boolean enabled;

    public BreakpointBase(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        this.line = line;
        this.column = column;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.actualLocations = list;
        this.condition = condition;
        this.enabled = enabled;
    }

    @NotNull
    public BreakpointTarget getTarget() {
        return this.target;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public int getColumn() {
        return this.column;
    }

    @NotNull
    public final List<L> getActualLocations() {
        return this.actualLocations;
    }

    protected final boolean getDirty() {
        return this.dirty;
    }

    protected final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public final boolean getPendingRemove() {
        return this.pendingRemove;
    }

    public final void setPendingRemove(boolean bl) {
        this.pendingRemove = bl;
    }

    public boolean isResolved() {
        return !this.actualLocations.isEmpty();
    }

    @Nullable
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.condition, (Object)value)) {
            this.condition = value;
            this.dirty = true;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        if (value != this.enabled) {
            this.enabled = value;
            this.dirty = true;
        }
    }

    public final void setActualLocations(@Nullable List<? extends L> value) {
        this.actualLocations.clear();
        if (!ContainerUtil.isEmpty((Collection)value)) {
            List<? extends L> list = value;
            Intrinsics.checkNotNull(list);
            this.actualLocations.addAll((Collection)list);
        }
    }

    public final void setActualLocation(@Nullable L value) {
        this.actualLocations.clear();
        if (value != null) {
            this.actualLocations.add(value);
        }
    }

    @NotNull
    public abstract Promise<?> vmRegistered();

    public int hashCode() {
        int result = this.getLine();
        result *= 31 + this.getColumn();
        result *= 31 + (this.getEnabled() ? 1 : 0);
        if (this.getCondition() != null) {
            String string = this.getCondition();
            Intrinsics.checkNotNull((Object)string);
            result *= 31 + string.hashCode();
        }
        return result *= 31 + this.getTarget().hashCode();
    }

    @NotNull
    public abstract Promise<? extends Breakpoint> flush(@NotNull BreakpointManager var1);
}

