/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "()V", "perform", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class VisualizeSourceMapAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap sourceMap, @NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile generatedFile = null;
        if (sourceMap.getOutFile() == null) {
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            if (StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                generatedFile = file2.getParent().findChild(StringsKt.removeSuffix((String)fileName, (CharSequence)".map"));
            }
        } else {
            VirtualFile virtualFile = file2.getParent();
            String string = sourceMap.getOutFile();
            Intrinsics.checkNotNull((Object)string);
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string);
            if (virtualFile2 == null) {
                String string2 = sourceMap.getOutFile();
                Intrinsics.checkNotNull((Object)string2);
                virtualFile2 = generatedFile = LocalFileFinder.findFile((String)string2);
            }
        }
        if (generatedFile == null) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)((FileType)JavaScriptFileType.INSTANCE));
            descriptor.setTitle(JSDebuggerBundle.message("js.scripts.visualize.select.generated", new Object[0]));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)file2.getParent(), arg_0 -> VisualizeSourceMapAction.perform$lambda$0((Function1)new Function1<VirtualFile, Unit>(sourceMap, project){
                final /* synthetic */ SourceMap $sourceMap;
                final /* synthetic */ Project $project;
                {
                    this.$sourceMap = $sourceMap;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(VirtualFile it) {
                    Intrinsics.checkNotNull((Object)it);
                    VisualizeSourceMapActionKt.visualizeMap$default(this.$sourceMap, it, null, this.$project, null, 16, null);
                }
            }, arg_0));
        } else {
            VisualizeSourceMapActionKt.visualizeMap$default(sourceMap, generatedFile, null, project, null, 16, null);
        }
    }

    private static final void perform$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

