/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.AddSourceContentsActionKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/AddSourceContentsAction;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "()V", "perform", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class AddSourceContentsAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap sourceMap, @NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[]{SourceMapInspectorKt.getFileTitle(file2)};
        String string = JSDebuggerBundle.message("js.scripts.visualize.action.add.content", objectArray);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, file2, sourceMap, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ SourceMap $sourceMap;
            {
                this.$project = $project;
                this.$file = $file;
                this.$sourceMap = $sourceMap;
                super($project, $super_call_param$1, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                String string;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                InputStreamReader reader = new InputStreamReader(this.$file.getInputStream(), Charsets.UTF_8);
                Map map = (Map)gson.fromJson((Reader)reader, (Type)((Object)Map.class));
                reader.close();
                if (map.containsKey("sourcesContent")) {
                    NotificationGroup notificationGroup = AddSourceContentsActionKt.access$getNOTIFICATION_GROUP();
                    String string2 = JSDebuggerBundle.message("js.scripts.visualize.action.add.content.notification", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    MessageType messageType = MessageType.INFO;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                    notificationGroup.createNotification(string2, messageType).notify(this.$project);
                    return;
                }
                V v = map.get("sources");
                Intrinsics.checkNotNull(v);
                List sources = (List)v;
                int n = 0;
                int n2 = sources.size();
                Object[] objectArray = new String[n2];
                while (n < n2) {
                    int n3 = n++;
                    VirtualFile virtualFile = SourceMapInspectorKt.getSourceFile(this.$sourceMap.getSources()[n3]);
                    Intrinsics.checkNotNull((Object)virtualFile);
                    objectArray[n3] = VfsUtilCore.loadText((VirtualFile)virtualFile);
                }
                Object[] sourcesContent = objectArray;
                map.put("sourcesContent", ArraysKt.toList((Object[])sourcesContent));
                String string3 = this.$file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                String path = string3;
                int index = StringsKt.lastIndexOf$default((CharSequence)path, (String)".map", (int)0, (boolean)false, (int)6, null);
                String ext = ".source.map";
                if (index > -1) {
                    String string4 = path.substring(0, index);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                } else {
                    string = path;
                }
                File outFile = new File(string + ext);
                OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), Charsets.UTF_8);
                Closeable closeable = stream;
                Object[] objectArray2 = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl = false;
                    gson.toJson((Object)map, (Appendable)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable object) {
                    objectArray2 = object;
                    throw object;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)objectArray2);
                }
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outFile);
                NotificationGroup notificationGroup = AddSourceContentsActionKt.access$getNOTIFICATION_GROUP();
                objectArray2 = new Object[]{outFile.getName()};
                String string5 = JSDebuggerBundle.message("js.scripts.visualize.action.add.content.notification.created", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                notificationGroup.createNotification(string5, messageType).notify(this.$project);
            }
        });
    }
}

