/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.google.common.collect.BiMap;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J@\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/SourceMapCollector;", "", "list", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "trimFileScheme", "", "(Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;Z)V", "collect", "", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "processScript", "baseUrl", "Lcom/intellij/util/Url;", "file", "Ljava/nio/file/Path;", "resolveSourcemaps", "dir", "root", "checkJs", "checkMap", "level", "", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nSourceMapCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapCollector.kt\ncom/intellij/javascript/debugger/sourcemap/SourceMapCollector\n+ 2 path.kt\ncom/intellij/util/io/PathKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n169#2,2:114\n172#2,2:120\n1#3:116\n86#4,3:117\n86#4,3:122\n*S KotlinDebug\n*F\n+ 1 SourceMapCollector.kt\ncom/intellij/javascript/debugger/sourcemap/SourceMapCollector\n*L\n46#1:114,2\n46#1:120,2\n85#1:117,3\n97#1:122,3\n*E\n"})
public final class SourceMapCollector {
    @NotNull
    private final PreloadedSourceMapList list;
    private final boolean trimFileScheme;

    public SourceMapCollector(@NotNull PreloadedSourceMapList list, boolean trimFileScheme) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.list = list;
        this.trimFileScheme = trimFileScheme;
    }

    public final void collect(@NotNull BiMap<String, VirtualFile> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        for (VirtualFile file2 : (Set)mappings.values()) {
            Url it;
            Path ioDir = Paths.get(file2.getPath(), new String[0]);
            Intrinsics.checkNotNull((Object)ioDir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(ioDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || ioDir.isAbsolute() && ioDir.getParent() == null) continue;
            Object object = mappings.inverse().get((Object)file2);
            Intrinsics.checkNotNull((Object)object);
            if (Urls.parseFromIdea((CharSequence)((CharSequence)object)) == null) continue;
            boolean bl = false;
            SourceMapCollector.resolveSourcemaps$default(this, ioDir, it, null, false, false, 0, 60, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void resolveSourcemaps(@NotNull Path dir, @NotNull Url baseUrl, @Nullable String root, boolean checkJs, boolean checkMap, int level) {
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        if (dir.isAbsolute() && dir.getParent() == null) {
            JavaScriptDebugProcessKt.getLOG().warn("Source maps are searched in FS root: " + dir);
            return;
        }
        SmartList children = null;
        Object object = dir;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(checkJs, checkMap){
            final /* synthetic */ boolean $checkJs;
            final /* synthetic */ boolean $checkMap;
            {
                this.$checkJs = $checkJs;
                this.$checkMap = $checkMap;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Path it) {
                boolean bl;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (Files.isHidden(it)) {
                            return false;
                        }
                        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)it);
                        if (basicFileAttributes == null) {
                            return false;
                        }
                        BasicFileAttributes attributes = basicFileAttributes;
                        if (attributes.isDirectory() && !Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)"node_modules")) break block5;
                        if (!attributes.isRegularFile()) break block6;
                        String string = ((Object)it.getFileName()).toString();
                        boolean bl2 = this.$checkJs;
                        boolean bl3 = this.$checkMap;
                        String $this$invoke_u24lambda_u240 = string;
                        boolean bl4 = false;
                        if (!(bl2 && StringsKt.endsWith$default((String)$this$invoke_u24lambda_u240, (String)".js", (boolean)false, (int)2, null) || bl3 && StringsKt.endsWith$default((String)$this$invoke_u24lambda_u240, (String)".map", (boolean)false, (int)2, null))) break block6;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        };
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Unit unit;
            void $this$directoryStreamIfExists$iv;
            closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, PathKt.makeFilter((Function1)filter$iv));
            throwable = null;
            try {
                String string;
                DirectoryStream it = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = it.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                if (!iterator2.hasNext()) {
                    return;
                }
                String dirPath = ((Object)dir.toAbsolutePath()).toString();
                String string2 = root;
                if (string2 != null) {
                    String it2 = string2;
                    boolean bl2 = false;
                    string = FileUtilRt.getRelativePath((String)root, (String)dirPath, (char)File.separatorChar) + File.separatorChar;
                } else {
                    string = null;
                }
                String dirRelativePathWithSeparator = string;
                Url baseLocalFsUrl = Urls.newLocalFileUrl((String)dirPath);
                children = new SmartList();
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Object object2;
                    Path file2 = (Path)iterator3.next();
                    LinkOption[] cfr_ignored_0 = new LinkOption[0];
                    Intrinsics.checkNotNull((Object)file2);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        if (level > 4) {
                            JavaScriptDebugProcessKt.getLOG().warn("Sourcemaps are not collected in " + file2 + ": deep > 4");
                            continue;
                        }
                        Url url = baseUrl.resolve(((Object)file2.getFileName()).toString());
                        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"resolve(...)");
                        this.resolveSourcemaps(file2, url, root, checkJs, checkMap, level + 1);
                        continue;
                    }
                    String fileName = ((Object)file2.getFileName()).toString();
                    if (checkJs && !StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                        ((List)children).add(file2);
                        continue;
                    }
                    Logger $this$runAndLogException$iv = JavaScriptDebugProcessKt.getLOG();
                    boolean $i$f$runAndLogException = false;
                    Logger logger = $this$runAndLogException$iv;
                    try {
                        Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (SourceMapDecoderKt.decodeSourceMapFromFile((Path)file2, (boolean)this.trimFileScheme, (Url)baseLocalFsUrl, (boolean)false) != null) {
                            Url scriptUrl;
                            SourceMap map;
                            String string3 = map.getOutFile();
                            if (string3 == null) {
                                String string4 = fileName.substring(0, fileName.length() - 4);
                                string3 = string4;
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                            }
                            String scriptFileName = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)baseUrl.resolve(scriptFileName), (String)"resolve(...)");
                            String string5 = dirRelativePathWithSeparator;
                            String mapPath = string5 != null ? string5 + scriptFileName : null;
                            Url url = baseUrl.resolve(fileName);
                            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"resolve(...)");
                            this.list.add(url, map, scriptUrl, mapPath, file2);
                        }
                        object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable2) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    LoggerKt.getOrLogException((Object)object2, (Logger)$this$runAndLogException$iv);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = unit;
        }
        catch (NoSuchFileException _$iv) {
            closeable = null;
        }
        object = (Collection)children;
        if (!(object == null || object.isEmpty())) {
            SmartList smartList = children;
            Intrinsics.checkNotNull(smartList);
            for (Path file3 : (List)smartList) {
                Object object3;
                Logger $this$runAndLogException$iv = JavaScriptDebugProcessKt.getLOG();
                boolean $i$f$runAndLogException = false;
                throwable = $this$runAndLogException$iv;
                try {
                    Throwable $this$runAndLogException_u24lambda_u240$iv = throwable;
                    boolean bl = false;
                    boolean bl5 = false;
                    this.processScript(baseUrl, file3);
                    object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable4) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable4));
                }
                LoggerKt.getOrLogException((Object)object3, (Logger)$this$runAndLogException$iv);
            }
        }
    }

    public static /* synthetic */ void resolveSourcemaps$default(SourceMapCollector sourceMapCollector, Path path, Url url, String string, boolean bl, boolean bl2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        sourceMapCollector.resolveSourcemaps(path, url, string, bl, bl2, n);
    }

    private final void processScript(Url baseUrl, Path file2) {
        block2: {
            String sourceMapUrl = SourceMapLoaderKt.getSourceMapUrl(file2);
            if (sourceMapUrl == null || !URLUtil.isDataUri((String)sourceMapUrl)) break block2;
            Url url = baseUrl.resolve(((Object)file2.getFileName()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"resolve(...)");
            Url scriptUrl = url;
            CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(sourceMapUrl, scriptUrl);
            if (charSequence == null) {
                return;
            }
            CharSequence data = charSequence;
            SourceMap sourceMap = SourceMapDecoderKt.decodeSourceMapSafely((CharSequence)data, (boolean)this.trimFileScheme, (Url)baseUrl, (boolean)false);
            if (sourceMap != null) {
                SourceMap it = sourceMap;
                boolean bl = false;
                PreloadedSourceMapList.add$default(this.list, scriptUrl, it, scriptUrl, null, null, 24, null);
            }
        }
    }
}

