/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.javascript.debugger.JSCachingFileFinderKt;
import com.intellij.javascript.debugger.locationResolving.FileUrlMapping;
import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/FileUrlMappingsStorage;", "", "()V", "fileToUrlMap", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/javascript/debugger/locationResolving/FileUrlMapping;", "urlToFileMap", "Lcom/intellij/util/Url;", "urlToScriptHashCode", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "addMapping", "", "mapping", "findSuitableMapping", "url", "accuracy", "Lcom/intellij/javascript/debugger/locationResolving/SearchAccuracy;", "findUrls", "", "file", "removeMapping", "removeOutdatedResults", "sourceContent", "", "scriptFound", "script", "Lorg/jetbrains/debugger/Script;", "intellij.javascript.debugger"})
final class FileUrlMappingsStorage {
    @NotNull
    private final Object2IntOpenHashMap<Url> urlToScriptHashCode = new Object2IntOpenHashMap();
    @NotNull
    private final MultiMap<Url, FileUrlMapping> urlToFileMap;
    @NotNull
    private final MultiMap<VirtualFile, FileUrlMapping> fileToUrlMap;

    public FileUrlMappingsStorage() {
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        this.urlToFileMap = multiMap;
        MultiMap multiMap2 = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"create(...)");
        this.fileToUrlMap = multiMap2;
    }

    public final synchronized void scriptFound(@NotNull Url url, @NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (this.urlToScriptHashCode.containsKey((Object)url)) {
            int scriptHashCode = this.urlToScriptHashCode.getInt((Object)url);
            if (scriptHashCode == script.hashCode()) {
                return;
            }
            this.urlToScriptHashCode.put((Object)url, script.hashCode());
            ArrayList outdatedMappings = new ArrayList(this.urlToFileMap.get((Object)url));
            for (FileUrlMapping outdatedMapping : outdatedMappings) {
                Intrinsics.checkNotNull((Object)outdatedMapping);
                this.removeMapping(outdatedMapping);
            }
        } else {
            this.urlToScriptHashCode.put((Object)url, script.hashCode());
            ArrayList mappingsToCheck = new ArrayList(this.urlToFileMap.get((Object)url));
            ArrayList<FileUrlMapping> mappingsToAdd = new ArrayList<FileUrlMapping>();
            for (FileUrlMapping mappingToCheck : mappingsToCheck) {
                if (mappingToCheck.getFile() == null || JSCachingFileFinderKt.isFileMatchingScript(mappingToCheck.getFile(), script)) continue;
                mappingsToAdd.add(mappingToCheck.copyWithNoFile());
                Intrinsics.checkNotNull((Object)mappingToCheck);
                this.removeMapping(mappingToCheck);
            }
            for (FileUrlMapping mappingToAdd : mappingsToAdd) {
                Intrinsics.checkNotNull((Object)mappingToAdd);
                this.addMapping(mappingToAdd);
            }
        }
    }

    public final synchronized void removeOutdatedResults(@NotNull Url url, @Nullable String sourceContent) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ArrayList mappingsToCheck = new ArrayList(this.urlToFileMap.get((Object)url));
        for (FileUrlMapping mapping : mappingsToCheck) {
            boolean fileContentIsUpToDate = mapping.getFile() != null ? mapping.getFile().getModificationStamp() == mapping.getFileOrFsModificationStamp() && !FileDocumentManager.getInstance().isFileModified(mapping.getFile()) : VirtualFileManager.getInstance().getStructureModificationCount() == mapping.getFileOrFsModificationStamp() && (sourceContent == null || sourceContent.hashCode() == mapping.getContentHashCode());
            if (fileContentIsUpToDate) continue;
            Intrinsics.checkNotNull((Object)mapping);
            this.removeMapping(mapping);
        }
    }

    private final void removeMapping(FileUrlMapping mapping) {
        this.urlToFileMap.remove((Object)mapping.getUrl(), (Object)mapping);
        if (mapping.getFile() != null) {
            this.fileToUrlMap.remove((Object)mapping.getFile(), (Object)mapping);
        }
    }

    public final synchronized void addMapping(@NotNull FileUrlMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        ArrayList candidateUrlMappings = new ArrayList(this.urlToFileMap.get((Object)mapping.getUrl()));
        for (FileUrlMapping candidateMapping : candidateUrlMappings) {
            if (!mapping.dominates(candidateMapping.getFile() != null, candidateMapping.getAccuracy())) continue;
            Intrinsics.checkNotNull((Object)candidateMapping);
            this.removeMapping(candidateMapping);
        }
        this.urlToFileMap.putValue((Object)mapping.getUrl(), (Object)mapping);
        if (mapping.getFile() != null) {
            ArrayList candidateFileMappings = new ArrayList(this.fileToUrlMap.get((Object)mapping.getFile()));
            for (FileUrlMapping candidateMapping : candidateFileMappings) {
                if (!mapping.dominates(candidateMapping.getFile() != null, candidateMapping.getAccuracy())) continue;
                Intrinsics.checkNotNull((Object)candidateMapping);
                this.removeMapping(candidateMapping);
            }
            this.fileToUrlMap.putValue((Object)mapping.getFile(), (Object)mapping);
        }
    }

    @Nullable
    public final synchronized FileUrlMapping findSuitableMapping(@NotNull Url url, @NotNull SearchAccuracy accuracy) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)accuracy), (String)"accuracy");
        for (FileUrlMapping mapping : this.urlToFileMap.get((Object)url)) {
            if (!mapping.dominates(true, accuracy) || !mapping.dominates(false, accuracy)) continue;
            return mapping;
        }
        return null;
    }

    @NotNull
    public final synchronized List<Url> findUrls(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List result = new ArrayList();
        SearchAccuracy bestMatch = SearchAccuracy.BY_NAME;
        for (FileUrlMapping mapping : this.fileToUrlMap.get((Object)file2)) {
            if (mapping.getAccuracy().compareTo((Enum)bestMatch) < 0) {
                result = new ArrayList();
                bestMatch = mapping.getAccuracy();
            }
            if (mapping.getAccuracy() != bestMatch) continue;
            result.add(mapping.getUrl());
        }
        return result;
    }
}

