/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.JSRemoteUrlMappingModel;
import com.intellij.javascript.debugger.execution.JSRemoteUrlMappingTableFactory;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.xdebugger.XDebuggerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\u001c\u0010\u0019\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0007\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/execution/JSLocalFilesMappingPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "layout", "Ljava/awt/LayoutManager;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/LayoutManager;)V", "mappingTreePanel", "getMappingTreePanel", "()Ljavax/swing/JPanel;", "myModel", "Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingModel;", "applyEditorTo", "", "mappings", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "createMapping", "localPath", "", "remote", "getBaseUrl", "initUI", "resetEditorFrom", "allowConfigureMappings", "", "intellij.javascript.debugger"})
public class JSLocalFilesMappingPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel mappingTreePanel;
    @NotNull
    private final JSRemoteUrlMappingModel myModel;

    public JSLocalFilesMappingPanel(@NotNull Project project, @NotNull LayoutManager layout) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        super(layout);
        this.project = project;
        this.mappingTreePanel = new JPanel(new BorderLayout());
        String[] stringArray = new String[2];
        Intrinsics.checkNotNullExpressionValue((Object)LangBundle.message((String)"column.name.file.directory", (Object[])new Object[0]), (String)"message(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JSDebuggerBundle.message("column.title.remote.url", new Object[0]), (String)"message(...)");
        this.myModel = new JSRemoteUrlMappingModel(stringArray);
    }

    @NotNull
    protected final JPanel getMappingTreePanel() {
        return this.mappingTreePanel;
    }

    public void initUI() {
        if (!this.project.isDefault()) {
            JBTable table = new JBTable((TableModel)this.myModel);
            JPanel tablePanel2 = new JSRemoteUrlMappingTableFactory(this.myModel, table, this.project, (Function0<String>)((Function0)new Function0<String>((Object)this){

                @NotNull
                public final String invoke() {
                    return ((JSLocalFilesMappingPanel)this.receiver).getBaseUrl();
                }
            })).createPanel();
            this.mappingTreePanel.add(ScrollPaneFactory.createScrollPane((Component)tablePanel2));
        } else {
            this.setVisible(false);
        }
    }

    public final void resetEditorFrom(@NotNull List<RemoteUrlMappingBean> mappings, boolean allowConfigureMappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        if (!allowConfigureMappings) {
            this.setVisible(false);
        } else if (!this.project.isDefault()) {
            this.myModel.getData().clear();
            this.myModel.getData().addAll((Collection<RemoteUrlMappingBean>)mappings);
        }
    }

    public final void applyEditorTo(@NotNull List<RemoteUrlMappingBean> mappings, @NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (!this.project.isDefault()) {
            mappings.clear();
            for (RemoteUrlMappingBean mapping : this.myModel.getData()) {
                String remote = mapping.getRemoteUrl();
                Intrinsics.checkNotNull((Object)remote);
                if (((CharSequence)remote).length() == 0) continue;
                String string = mapping.localFilePath;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localFilePath");
                mappings.add(this.createMapping(string, remote));
            }
            for (JavaScriptDebugProcess process2 : XDebuggerManager.getInstance((Project)this.project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                if (process2.getSession().getRunProfile() != configuration) continue;
                process2.updateRemoteUrlMappings(mappings);
            }
        }
    }

    @NotNull
    protected RemoteUrlMappingBean createMapping(@NotNull String localPath, @NotNull String remote) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return new RemoteUrlMappingBean(localPath, remote);
    }

    @NotNull
    public String getBaseUrl() {
        return "http://";
    }
}

