/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.DebuggableRunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.debugger.DebugPortConfigurator;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.nodejs.debug.NodeDebuggableRunProfileState;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010'\u001a\b\u0012\u0004\u0012\u00020 0%2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020 0%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lcom/intellij/javascript/debugger/execution/DebuggableProcessState;", "T", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/execution/runners/DebuggableRunProfileState;", "Lcom/intellij/javascript/nodejs/debug/NodeDebuggableRunProfileState;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "getConfiguration", "()Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "inputPath", "", "getInputPath", "()Ljava/lang/String;", "addConsoleFilters", "", "builder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "addInputPathArg", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configureCommandLine", "debugPort", "", "configureEnvironment", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "createProcessHandler", "configurator", "Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ExecutionResult;", "startProcess", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nDebuggableProcessState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggableProcessState.kt\ncom/intellij/javascript/debugger/execution/DebuggableProcessState\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n13#2:112\n*S KotlinDebug\n*F\n+ 1 DebuggableProcessState.kt\ncom/intellij/javascript/debugger/execution/DebuggableProcessState\n*L\n41#1:112\n*E\n"})
public abstract class DebuggableProcessState<T extends DebuggableProcessRunConfiguration>
implements DebuggableRunProfileState,
NodeDebuggableRunProfileState {
    @NotNull
    private final T configuration;
    @NotNull
    private final ExecutionEnvironment environment;

    public DebuggableProcessState(@NotNull T configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
    }

    @NotNull
    protected final T getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public Promise<ExecutionResult> execute(@Nullable CommandLineDebugConfigurator configurator) {
        Promise promise2 = this.startProcess(new GeneralCommandLine(), configurator).then(arg_0 -> DebuggableProcessState.execute$lambda$0((Function1)new Function1<ProcessHandler, ExecutionResult>(this){
            final /* synthetic */ DebuggableProcessState<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ExecutionResult invoke(ProcessHandler it) {
                Intrinsics.checkNotNull((Object)it);
                return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)DebuggableProcessState.access$createConsole(this.this$0, it), it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @NotNull
    public Promise<ExecutionResult> execute(int debugPort) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodeDebuggableRunProfileState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Please call execute(CommandLineDebugConfigurator) instead: " + this.getClass());
        return this.execute((CommandLineDebugConfigurator)DebugPortConfigurator.Companion.new(debugPort));
    }

    private final ConsoleView createConsole(ProcessHandler processHandler) {
        Project project = this.environment.getProject();
        TextConsoleBuilderImpl consoleBuilder2 = new TextConsoleBuilderImpl(this, project){
            final /* synthetic */ DebuggableProcessState<T> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @NotNull
            protected ConsoleView createConsole() {
                Project project = this.this$0.getEnvironment().getProject();
                GlobalSearchScope globalSearchScope = this.getScope();
                boolean bl = this.isViewer();
                return (ConsoleView)new ConsoleViewImpl(this.this$0, project, globalSearchScope, bl){
                    final /* synthetic */ DebuggableProcessState<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3, true);
                    }

                    @Nullable
                    public Object getData(@NotNull String dataId) {
                        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                        Object object = super.getData(dataId);
                        if (object == null) {
                            object = LangDataKeys.RUN_PROFILE.is(dataId) ? this.this$0.getEnvironment().getRunProfile() : null;
                        }
                        return object;
                    }
                };
            }
        };
        this.addConsoleFilters((TextConsoleBuilder)consoleBuilder2);
        ConsoleView consoleView = consoleBuilder2.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView console = consoleView;
        console.attachToProcess(processHandler);
        return console;
    }

    protected void addConsoleFilters(@NotNull TextConsoleBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    @NotNull
    protected String getInputPath() {
        String string = this.configuration.getInputPath();
        if (string == null) {
            throw new ExecutionException(JSDebuggerBundle.message("error.message.input.path.not.specified", new Object[0]));
        }
        String inputPath = string;
        if (ScriptFileUtil.isMemoryScriptPath((String)inputPath)) {
            return inputPath;
        }
        String string2 = FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.environment.getProject())).expandPath(inputPath));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        return string2;
    }

    @NotNull
    protected Promise<ProcessHandler> startProcess(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return this.startProcess(commandLine, (CommandLineDebugConfigurator)DebugPortConfigurator.Companion.new(debugPort));
    }

    @NotNull
    protected Promise<ProcessHandler> startProcess(@NotNull GeneralCommandLine commandLine, @Nullable CommandLineDebugConfigurator configurator) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        DebugPortConfigurator debugPortConfigurator = configurator instanceof DebugPortConfigurator ? (DebugPortConfigurator)configurator : null;
        int debugPort = debugPortConfigurator != null ? debugPortConfigurator.getDebugPort() : -1;
        this.configureCommandLine(commandLine, debugPort);
        this.configureEnvironment(commandLine);
        CommandLineDebugConfigurator commandLineDebugConfigurator = configurator;
        if (commandLineDebugConfigurator != null) {
            commandLineDebugConfigurator.afterBaseConfiguring(commandLine);
        }
        ProcessHandler processHandler = this.createProcessHandler(commandLine, configurator);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)this.environment.getProject());
        return Promises.resolvedPromise((Object)processHandler);
    }

    protected void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        commandLine.withEnvironment(this.configuration.getEnvs());
        commandLine.withParentEnvironmentType(this.configuration.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    protected final void addInputPathArg(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        String[] stringArray = new String[]{this.getInputPath()};
        commandLine.addParameters(stringArray);
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, @Nullable CommandLineDebugConfigurator configurator) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return (ProcessHandler)new OSProcessHandler(commandLine);
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            String string = this.configuration.getEffectiveExePath();
            if (string == null) {
                throw new ExecutionException(JSDebuggerBundle.message("error.message.exe.path.not.specified", new Object[0]));
            }
            String exePath = string;
            commandLine.setExePath(this.configuration.correctExePath(exePath));
            String string2 = this.configuration.getEffectiveWorkingDirectory();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            commandLine.withWorkDirectory(it);
        }
    }

    private static final ExecutionResult execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ExecutionResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConsoleView access$createConsole(DebuggableProcessState $this, ProcessHandler processHandler) {
        return $this.createConsole(processHandler);
    }
}

