/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console.jcef;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.JSBridge;
import com.intellij.javascript.debugger.console.ResourcesStaticServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 P2\u00020\u00012\u00020\u0002:\u0001PB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0016J>\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\r2\n\u0010(\u001a\u00060)j\u0002`*2\u0006\u0010+\u001a\u00020\u00072\u0018\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0-\u0012\u0004\u0012\u00020\u000e0\fH\u0002J7\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\r2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010-2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016\u00a2\u0006\u0002\u00103J)\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\r2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u0002010-\"\u000201H\u0016\u00a2\u0006\u0002\u00104J\u0016\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u00020\u000eH\u0016J\u0012\u0010<\u001a\u0004\u0018\u0001012\u0006\u0010=\u001a\u00020\rH\u0016J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\rH\u0016J\u0016\u0010@\u001a\u00020\u000e2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\b\u0010B\u001a\u00020\u000eH\u0002J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0016J*\u0010D\u001a\u00020\u000e2 \u0010E\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002010-0G0FH\u0016J\u0016\u0010H\u001a\u00020\u000e2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020OH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\t\u001a6\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\nj\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\"\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/intellij/javascript/debugger/console/jcef/JCEFConsoleHtmlPanel;", "Lcom/intellij/ui/jcef/JCEFHtmlPanel;", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "()V", "cefLoadHandler", "Lorg/cef/handler/CefLoadHandler;", "collapseQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "Lorg/jetbrains/annotations/NotNull;", "executeCallbackMap", "Ljava/util/HashMap;", "", "Lkotlin/Function1;", "", "", "Lkotlin/collections/HashMap;", "executeQuery", "executeQueryId", "Ljava/util/concurrent/atomic/AtomicInteger;", "expandQuery", "hideHighlightQuery", "highlightQuery", "initHandler", "Lkotlin/Function0;", "logQuery", "messageNodeQuery", "navigateQuery", "nodeLinkClickQuery", "pageLoaded", "", "pageUrl", "tasks", "", "Ljava/lang/Runnable;", "updateStickToEndQuery", "addKeyListener", "keyListener", "Ljava/awt/event/KeyListener;", "bindMethod", "name", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "query", "invoke", "", "callJS", "method", "args", "", "callback", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "cefToAwtKeyEvent", "Ljava/awt/event/KeyEvent;", "event", "Lorg/cef/handler/CefKeyboardHandler$CefKeyEvent;", "uiComponent", "Ljava/awt/Component;", "dispose", "executeScript", "s", "load", "mainUrl", "onInit", "function", "pageInit", "removeKeyListener", "runRequestsBatch", "batch", "", "Lkotlin/Pair;", "runWhenPageReady", "runnable", "setBackground", "background", "Ljava/awt/Color;", "setBridge", "jsBridge", "Lcom/intellij/javascript/debugger/console/JSBridge;", "Companion", "intellij.javascript.debugger"})
public final class JCEFConsoleHtmlPanel
extends JCEFHtmlPanel
implements ConsoleHtmlPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CefLoadHandler cefLoadHandler;
    private boolean pageLoaded;
    @Nullable
    private String pageUrl;
    @NotNull
    private final List<Runnable> tasks = new ArrayList();
    @Nullable
    private Function0<Unit> initHandler;
    @NotNull
    private final JBCefJSQuery navigateQuery;
    @NotNull
    private final JBCefJSQuery expandQuery;
    @NotNull
    private final JBCefJSQuery highlightQuery;
    @NotNull
    private final JBCefJSQuery hideHighlightQuery;
    @NotNull
    private final JBCefJSQuery updateStickToEndQuery;
    @NotNull
    private final JBCefJSQuery nodeLinkClickQuery;
    @NotNull
    private final JBCefJSQuery logQuery;
    @NotNull
    private final JBCefJSQuery messageNodeQuery;
    @NotNull
    private final JBCefJSQuery collapseQuery;
    @NotNull
    private final JBCefJSQuery executeQuery;
    @NotNull
    private final HashMap<Integer, Function1<String, Unit>> executeCallbackMap;
    @NotNull
    private final AtomicInteger executeQueryId;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Gson gson;

    public JCEFConsoleHtmlPanel() {
        super(true, null, ResourcesStaticServer.Companion.getMainUrl());
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.ui.jcef.JBCefBrowserBase");
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        this.navigateQuery = jBCefJSQuery;
        JBCefJSQuery jBCefJSQuery2 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery2, (String)"create(...)");
        this.expandQuery = jBCefJSQuery2;
        JBCefJSQuery jBCefJSQuery3 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery3, (String)"create(...)");
        this.highlightQuery = jBCefJSQuery3;
        JBCefJSQuery jBCefJSQuery4 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery4, (String)"create(...)");
        this.hideHighlightQuery = jBCefJSQuery4;
        JBCefJSQuery jBCefJSQuery5 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery5, (String)"create(...)");
        this.updateStickToEndQuery = jBCefJSQuery5;
        JBCefJSQuery jBCefJSQuery6 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery6, (String)"create(...)");
        this.nodeLinkClickQuery = jBCefJSQuery6;
        JBCefJSQuery jBCefJSQuery7 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery7, (String)"create(...)");
        this.logQuery = jBCefJSQuery7;
        JBCefJSQuery jBCefJSQuery8 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery8, (String)"create(...)");
        this.messageNodeQuery = jBCefJSQuery8;
        JBCefJSQuery jBCefJSQuery9 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery9, (String)"create(...)");
        this.collapseQuery = jBCefJSQuery9;
        JBCefJSQuery jBCefJSQuery10 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery10, (String)"create(...)");
        this.executeQuery = jBCefJSQuery10;
        this.executeCallbackMap = new HashMap();
        this.executeQueryId = new AtomicInteger(0);
        this.cefLoadHandler = (CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadError(@Nullable CefBrowser browser, @Nullable CefFrame frame, @Nullable CefLoadHandler.ErrorCode errorCode, @Nullable String errorText, @Nullable String failedUrl) {
                LOG.warn("Failed to load " + failedUrl + "\nErr " + errorCode + ": " + errorText);
            }

            public void onLoadingStateChange(@Nullable CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                CefBrowser cefBrowser;
                if (!isLoading && Intrinsics.areEqual((Object)((cefBrowser = browser) != null && (cefBrowser = cefBrowser.getMainFrame()) != null ? cefBrowser.getURL() : null), (Object)pageUrl)) {
                    this.pageInit();
                }
            }
        };
        this.executeQuery.addHandler(arg_0 -> JCEFConsoleHtmlPanel._init_$lambda$0((Function1)new Function1<String, JBCefJSQuery.Response>(){

            public final JBCefJSQuery.Response invoke(String it) {
                block0: {
                    String[] args = (String[])Companion.getGson().fromJson(it, String[].class);
                    Function1 function1 = (Function1)executeCallbackMap.remove(Integer.parseInt(args[0]));
                    if (function1 == null) break block0;
                    Function1 callback2 = function1;
                    boolean bl = false;
                    AppUIUtil.invokeOnEdt(() -> 2.invoke$lambda$1$lambda$0(callback2, args));
                }
                return null;
            }

            private static final void invoke$lambda$1$lambda$0(Function1 $callback, String[] $args) {
                Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                $callback.invoke((Object)$args[1]);
            }
        }, arg_0));
        this.getJBCefClient().addLoadHandler(this.cefLoadHandler, this.getCefBrowser());
    }

    @Override
    public void load(@NotNull String mainUrl) {
        Intrinsics.checkNotNullParameter((Object)mainUrl, (String)"mainUrl");
        this.pageLoaded = false;
        this.pageUrl = mainUrl;
        this.loadURL(mainUrl);
    }

    @Override
    @Nullable
    public Object executeScript(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.getCefBrowser().executeJavaScript(s, this.getCefBrowser().getURL(), 0);
        return null;
    }

    @Override
    public void runWhenPageReady(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        if (this.pageLoaded) {
            runnable.invoke();
        } else {
            this.tasks.add(() -> JCEFConsoleHtmlPanel.runWhenPageReady$lambda$1(runnable));
        }
    }

    @Override
    public void callJS(@NotNull String method, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String jsArgs = !(args.length == 0) ? "..." + gson.toJson((Object)args) : "";
        this.executeScript("WebConsole.instance()." + method + "(" + jsArgs + ");");
    }

    @Override
    public void callJS(@NotNull String method, @NotNull Object[] args, @NotNull Function1<? super String, Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        String jsArgs = !(args.length == 0) ? "..." + gson.toJson((Object)args) : "";
        int id = this.executeQueryId.incrementAndGet();
        Integer n = id;
        ((Map)this.executeCallbackMap).put(n, callback2);
        this.executeScript("(function () { let _res = WebConsole.instance()." + method + "(" + jsArgs + ");" + this.executeQuery.inject("JSON.stringify([" + id + ", _res]) ") + "})()");
    }

    @Override
    public void runRequestsBatch(@NotNull List<? extends Pair<String, ? extends Object[]>> batch) {
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        try {
            this.executeScript("window.processRequests(" + gson.toJson(batch) + ")");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void addKeyListener(@NotNull KeyListener keyListener2) {
        Intrinsics.checkNotNullParameter((Object)keyListener2, (String)"keyListener");
        this.getCefBrowser().getUIComponent().addKeyListener(keyListener2);
    }

    @Override
    public void removeKeyListener(@NotNull KeyListener keyListener2) {
        Intrinsics.checkNotNullParameter((Object)keyListener2, (String)"keyListener");
        this.getCefBrowser().getUIComponent().removeKeyListener(keyListener2);
    }

    @NotNull
    public final KeyEvent cefToAwtKeyEvent(@NotNull CefKeyboardHandler.CefKeyEvent event, @NotNull Component uiComponent) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)uiComponent, (String)"uiComponent");
        return new KeyEvent(uiComponent, 400, System.currentTimeMillis(), event.modifiers, event.windows_key_code, event.character);
    }

    @Override
    public void onInit(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.initHandler = function;
    }

    private final void pageInit() {
        if (!this.pageLoaded) {
            this.pageLoaded = true;
            LOG.info("WebConsole page loaded");
            Function0<Unit> function0 = this.initHandler;
            if (function0 != null) {
                function0.invoke();
            }
            for (Runnable task : this.tasks) {
                task.run();
            }
            this.tasks.clear();
            LOG.info("initialization complete");
        }
    }

    @Override
    public void setBridge(@NotNull JSBridge jsBridge) {
        Intrinsics.checkNotNullParameter((Object)jsBridge, (String)"jsBridge");
        StringBuilder sb = new StringBuilder();
        sb.append("window.JSBridge = {");
        this.bindMethod("navigate", sb, this.navigateQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.navigate(Integer.parseInt(it[0]));
            }
        }));
        this.bindMethod("expand", sb, this.expandQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.expand(Integer.parseInt(it[0]), Integer.parseInt(it[1]));
            }
        }));
        this.bindMethod("highlight", sb, this.highlightQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.highlight(Integer.parseInt(it[0]));
            }
        }));
        this.bindMethod("hideHighlight", sb, this.hideHighlightQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.hideHighlight(Integer.parseInt(it[0]));
            }
        }));
        this.bindMethod("collapse", sb, this.collapseQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.collapse(Integer.parseInt(it[0]));
            }
        }));
        this.bindMethod("messageNodeCallback", sb, this.messageNodeQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.messageNodeCallback(Integer.parseInt(it[0]));
            }
        }));
        this.bindMethod("updateStickToEnd", sb, this.updateStickToEndQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.updateStickToEnd(Boolean.parseBoolean(it[0]));
            }
        }));
        this.bindMethod("nodeLinkClick", sb, this.nodeLinkClickQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.nodeLinkClick(Integer.parseInt(it[0]));
            }
        }));
        this.bindMethod("log", sb, this.logQuery, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(jsBridge){
            final /* synthetic */ JSBridge $jsBridge;
            {
                this.$jsBridge = $jsBridge;
                super(1);
            }

            public final void invoke(@NotNull String[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$jsBridge.log(it[0]);
            }
        }));
        sb.append("};");
        this.getCefBrowser().executeJavaScript(sb.toString(), this.getCefBrowser().getURL(), 0);
    }

    private final void bindMethod(String name, StringBuilder sb, JBCefJSQuery query, Function1<? super String[], Unit> invoke) {
        String jsFun = name + " : function() {" + query.inject("JSON.stringify([...arguments])") + "},";
        sb.append(jsFun);
        query.addHandler(arg_0 -> JCEFConsoleHtmlPanel.bindMethod$lambda$2((Function1)new Function1<String, JBCefJSQuery.Response>(invoke){
            final /* synthetic */ Function1<String[], Unit> $invoke;
            {
                this.$invoke = $invoke;
                super(1);
            }

            public final JBCefJSQuery.Response invoke(String it) {
                String[] args = (String[])JCEFConsoleHtmlPanel.Companion.getGson().fromJson(it, String[].class);
                Intrinsics.checkNotNull((Object)args);
                this.$invoke.invoke((Object)args);
                return null;
            }
        }, arg_0));
        Disposer.register((Disposable)this, (Disposable)((Disposable)query));
    }

    @Override
    public void setBackground(@NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
    }

    public void dispose() {
        super.dispose();
        this.getJBCefClient().removeLoadHandler(this.cefLoadHandler, this.getCefBrowser());
        this.initHandler = null;
        this.tasks.clear();
    }

    private static final JBCefJSQuery.Response _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final void runWhenPageReady$lambda$1(Function0 $runnable) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        $runnable.invoke();
    }

    private static final JBCefJSQuery.Response bindMethod$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(JCEFConsoleHtmlPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        JCEFConsoleHtmlPanel.gson = gson;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/debugger/console/jcef/JCEFConsoleHtmlPanel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

