/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.DOMNode;
import com.intellij.javascript.debugger.console.DeferredEntity;
import com.intellij.javascript.debugger.console.HyperLink;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.console.LinkType;
import com.intellij.javascript.debugger.console.MessagePrinter;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.PrintableEntity;
import com.intellij.javascript.debugger.console.Text;
import com.intellij.javascript.debugger.console.TreeRoot;
import com.intellij.javascript.debugger.console.UrlsAndAnsiParser;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Url;
import com.intellij.xdebugger.frame.XValue;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B3\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J<\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J<\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010!\u001a\u00020\u000eH\u0016JJ\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010$\u001a\u00020\u000eH\u0016J\b\u0010%\u001a\u00020\u000eH\u0002J\b\u0010&\u001a\u00020\u000eH\u0016J,\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020\u000eH\u0016J\u0018\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0019H\u0016J\b\u00102\u001a\u00020\u000eH\u0016J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0019H\u0002J*\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u0019H\u0016J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\"\u0010=\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010>\u001a\u00020?H\u0002J\u001a\u0010@\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\u0018\u0010C\u001a\u00020\u000e2\u0006\u00109\u001a\u0002062\u0006\u00107\u001a\u00020\u0019H\u0016J\"\u0010D\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010H\u001a\u00020\u000eH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleMessageBuilder;", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "messageVm", "Lorg/jetbrains/debugger/Vm;", "printer", "Lcom/intellij/javascript/debugger/console/MessagePrinter;", "domPresentationProvider", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "disposableRoot", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;Lcom/intellij/javascript/debugger/console/MessagePrinter;Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;Lcom/intellij/openapi/Disposable;)V", "addHyperLink", "", "hyperlinkText", "", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "url", "suggestedLine", "", "suggestedColumn", "functionName", "resolveToScript", "", "scriptId", "addMessageLink", "append", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "style", "clear", "createLinkInfo", "Lkotlin/Pair;", "endMessage", "endTrace", "flush", "getLinkText", "parsedUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "rawUrl", "line", "groupEnd", "groupStart", "groupName", "collapsed", "increaseLastMessageRepeatCount", "prepareValueEntity", "Lcom/intellij/javascript/debugger/console/PrintableEntity;", "xValue", "Lcom/intellij/xdebugger/frame/XValue;", "xmlView", "printAndStoreValueToInspect", "value", "Lorg/jetbrains/debugger/values/Value;", "expression", "printBrowserLink", "printMessageHyperlink", "linkType", "Lcom/intellij/javascript/debugger/console/LinkType;", "printStackTrace", "stackTrace", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "printValue", "startMessage", "type", "Lcom/intellij/javascript/debugger/console/MessageType;", "source", "startTrace", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nWebConsoleMessageBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebConsoleMessageBuilder.kt\ncom/intellij/javascript/debugger/console/WebConsoleMessageBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n1#2:288\n1855#3,2:289\n*S KotlinDebug\n*F\n+ 1 WebConsoleMessageBuilder.kt\ncom/intellij/javascript/debugger/console/WebConsoleMessageBuilder\n*L\n285#1:289,2\n*E\n"})
public final class WebConsoleMessageBuilder
extends ConsoleMessageBuilder {
    @NotNull
    private final Vm messageVm;
    @NotNull
    private final MessagePrinter printer;
    @Nullable
    private final WebConsoleView.DOMPresentationProvider domPresentationProvider;
    @NotNull
    private final Disposable disposableRoot;

    public WebConsoleMessageBuilder(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm messageVm, @NotNull MessagePrinter printer, @Nullable WebConsoleView.DOMPresentationProvider domPresentationProvider, @NotNull Disposable disposableRoot) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)messageVm, (String)"messageVm");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)disposableRoot, (String)"disposableRoot");
        super(debugProcess);
        this.messageVm = messageVm;
        this.printer = printer;
        this.domPresentationProvider = domPresentationProvider;
        this.disposableRoot = disposableRoot;
    }

    @Override
    public void startMessage(@NotNull ConsoleViewContentType contentType, @NotNull MessageType type, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getTasks().add(new Function0<Unit>(contentType, source, this, type){
            final /* synthetic */ ConsoleViewContentType $contentType;
            final /* synthetic */ String $source;
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ MessageType $type;
            {
                this.$contentType = $contentType;
                this.$source = $source;
                this.this$0 = $receiver;
                this.$type = $type;
                super(0);
            }

            public final void invoke() {
                String string;
                String level;
                block3: {
                    block2: {
                        ConsoleViewContentType consoleViewContentType = this.$contentType;
                        level = "level-" + ((Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_ERROR_OUTPUT) ? true : Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.ERROR_OUTPUT)) ? "error" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_WARNING_OUTPUT) ? "warning" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_INFO_OUTPUT) ? "info" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_DEBUG_OUTPUT) ? "debug" : "log"))));
                        string = this.$source;
                        if (string == null) break block2;
                        String string2 = string;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        String string3 = string2.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        string = string3;
                        if (string3 != null) break block3;
                    }
                    string = "default";
                }
                String src = "source-" + string;
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).startMessage(this.$type, level, src);
            }
        });
    }

    @Override
    public void endMessage() {
    }

    @Override
    public void groupStart(@NotNull String groupName, boolean collapsed) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getTasks().add(new Function0<Unit>(this, groupName, collapsed){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ String $groupName;
            final /* synthetic */ boolean $collapsed;
            {
                this.this$0 = $receiver;
                this.$groupName = $groupName;
                this.$collapsed = $collapsed;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).startGroup(this.$groupName, this.$collapsed);
            }
        });
    }

    @Override
    public void groupEnd() {
        this.getTasks().add(new Function0<Unit>(this){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).endGroup();
            }
        });
    }

    @Override
    public void append(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable String style) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.getTasks().add(new Function0<Unit>(text, contentType, this, style){
            final /* synthetic */ String $text;
            final /* synthetic */ ConsoleViewContentType $contentType;
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ String $style;
            {
                this.$text = $text;
                this.$contentType = $contentType;
                this.this$0 = $receiver;
                this.$style = $style;
                super(0);
            }

            public final void invoke() {
                UrlsAndAnsiParser.INSTANCE.parseAndPrint(this.$text, this.$contentType, (Function3<? super String, ? super ConsoleViewContentType, ? super SimpleColoredText, Unit>)((Function3)new Function3<String, ConsoleViewContentType, SimpleColoredText, Unit>(this.this$0, this.$style){
                    final /* synthetic */ WebConsoleMessageBuilder this$0;
                    final /* synthetic */ String $style;
                    {
                        this.this$0 = $receiver;
                        this.$style = $style;
                        super(3);
                    }

                    public final void invoke(@NotNull String txt, @NotNull ConsoleViewContentType cType, @Nullable SimpleColoredText coloredText) {
                        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
                        Intrinsics.checkNotNullParameter((Object)cType, (String)"cType");
                        WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).print(new Text(txt, cType, coloredText, this.$style));
                    }
                }), (Function3<? super String, ? super HyperlinkInfo, ? super SimpleColoredText, Unit>)((Function3)new Function3<String, HyperlinkInfo, SimpleColoredText, Unit>(this.this$0){
                    final /* synthetic */ WebConsoleMessageBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(3);
                    }

                    public final void invoke(@NotNull String txt, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable SimpleColoredText simpleColoredText) {
                        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
                        Intrinsics.checkNotNullParameter((Object)hyperlinkInfo, (String)"hyperlinkInfo");
                        MessagePrinter messagePrinter = WebConsoleMessageBuilder.access$getPrinter$p(this.this$0);
                        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
                        messagePrinter.print(new HyperLink(txt, consoleViewContentType, hyperlinkInfo, LinkType.BROWSER, simpleColoredText));
                    }
                }));
            }
        });
    }

    @Override
    public void increaseLastMessageRepeatCount() {
        this.getTasks().add(new Function0<Unit>(this){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).increaseLastMessageRepeatCount();
            }
        });
    }

    @Override
    public void clear() {
        this.getTasks().add(new Function0<Unit>(this){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).clear();
            }
        });
    }

    @Override
    public void printStackTrace(@NotNull ConsoleViewContentType contentType, @Nullable StackTraceValue stackTrace) {
        StackTraceValue currentStackTrace;
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        if (stackTrace == null) {
            return;
        }
        if (stackTrace.callFrames().isEmpty() || Intrinsics.areEqual((Object)"undefined", (Object)((CallFrameValue)CollectionsKt.first((List)stackTrace.callFrames())).url())) {
            return;
        }
        int max = -1;
        for (currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            Comparable comparable;
            Iterator iterator = ((Iterable)currentStackTrace.callFrames()).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                CallFrameValue frame = (CallFrameValue)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(WebConsoleMessageBuilder.printStackTrace$frameName(frame).length());
                while (iterator.hasNext()) {
                    CallFrameValue frame2 = (CallFrameValue)iterator.next();
                    $i$a$-maxOfOrNull-WebConsoleMessageBuilder$printStackTrace$1 = false;
                    Comparable comparable3 = Integer.valueOf(WebConsoleMessageBuilder.printStackTrace$frameName(frame2).length());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            int n2 = n != null ? n : 0;
            max = Math.max(max, n2);
        }
        this.startTrace();
        for (currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            if (!Intrinsics.areEqual((Object)currentStackTrace, (Object)stackTrace)) {
                ConsoleMessageBuilder consoleMessageBuilder = this;
                Object[] objectArray = new Object[]{currentStackTrace.getDescription()};
                String string = JSDebuggerBundle.message("js.frame.async", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                ConsoleMessageBuilder.append$default(consoleMessageBuilder, string, contentType, null, 4, null);
                this.newLine();
            }
            for (CallFrameValue frame : currentStackTrace.callFrames()) {
                String functionName = WebConsoleMessageBuilder.printStackTrace$frameName(frame);
                ConsoleMessageBuilder.append$default(this, functionName, contentType, null, 4, null);
                ConsoleMessageBuilder consoleMessageBuilder = this;
                String string = StringUtil.repeatSymbol((char)' ', (int)(max - functionName.length()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeatSymbol(...)");
                ConsoleMessageBuilder.append$default(consoleMessageBuilder, string, null, null, 6, null);
                ConsoleMessageBuilder.append$default(this, "\t", contentType, null, 4, null);
                this.addHyperLink(frame.url(), frame.getLineNumber(), frame.getColumnNumber(), frame.functionName(), true, frame.scriptId());
                this.newLine();
            }
        }
        this.endTrace();
    }

    private final void startTrace() {
        this.getTasks().add(new Function0<Unit>(this){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).startTrace();
            }
        });
    }

    private final void endTrace() {
        this.getTasks().add(new Function0<Unit>(this){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).endTrace();
            }
        });
    }

    @Override
    public void printValue(@NotNull XValue value, boolean xmlView) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PrintableEntity printableEntity = this.prepareValueEntity(value, xmlView);
        if (printableEntity == null) {
            return;
        }
        PrintableEntity printableEntity2 = printableEntity;
        this.getTasks().add(new Function0<Unit>(this, printableEntity2){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ PrintableEntity $printableEntity;
            {
                this.this$0 = $receiver;
                this.$printableEntity = $printableEntity;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$getPrinter$p(this.this$0).print(this.$printableEntity);
            }
        });
    }

    private final PrintableEntity prepareValueEntity(XValue xValue, boolean xmlView) {
        if (!(xValue instanceof VariableView)) {
            return null;
        }
        Value value = ((VariableView)xValue).getValue();
        if (value == null) {
            return null;
        }
        Value value2 = value;
        Ref.ObjectRef contentType = new Ref.ObjectRef();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getValueKey(value2));
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
        contentType.element = consoleViewContentType;
        PrintableEntity printableEntity = null;
        if (value2 instanceof ObjectValue) {
            TreeRoot tree = new TreeRoot(((VariableView)xValue).getVariableName(), (ConsoleViewContentType)contentType.element, (VariableView)xValue, this.getDebugProcess(), this.disposableRoot, null, 32, null);
            Promise promise2 = (Promise)tree.getLoadPromise();
            if (value2.getType() == ValueType.NODE && this.domPresentationProvider != null && xmlView) {
                Promise promise3 = this.domPresentationProvider.getNodePresentation(value2).then(arg_0 -> WebConsoleMessageBuilder.prepareValueEntity$lambda$2((Function1)new Function1<ItemPresentation, PrintableEntity>(this, (Ref.ObjectRef<ConsoleViewContentType>)contentType){
                    final /* synthetic */ WebConsoleMessageBuilder this$0;
                    final /* synthetic */ Ref.ObjectRef<ConsoleViewContentType> $contentType;
                    {
                        this.this$0 = $receiver;
                        this.$contentType = $contentType;
                        super(1);
                    }

                    public final PrintableEntity invoke(@Nullable ItemPresentation itemPresentation) {
                        DOMNode dOMNode;
                        ItemPresentation itemPresentation2 = itemPresentation;
                        if (itemPresentation2 != null) {
                            ItemPresentation itemPresentation3 = itemPresentation2;
                            WebConsoleMessageBuilder webConsoleMessageBuilder = this.this$0;
                            Ref.ObjectRef<ConsoleViewContentType> objectRef = this.$contentType;
                            ItemPresentation it = itemPresentation3;
                            boolean bl = false;
                            dOMNode = DOMNode.Companion.createDOMNode(itemPresentation, WebConsoleMessageBuilder.access$getDomPresentationProvider$p(webConsoleMessageBuilder), (ConsoleViewContentType)objectRef.element);
                        } else {
                            dOMNode = null;
                        }
                        return dOMNode;
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"then(...)");
                promise2 = promise3;
            }
            printableEntity = new DeferredEntity((Promise<PrintableEntity>)promise2, tree);
        } else {
            String text;
            String string = value2.getValueString();
            if (string == null) {
                string = "undefined";
            }
            if (Intrinsics.areEqual((Object)(text = string), (Object)"undefined")) {
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.getConsoleViewType(ConsoleMessageBuilder.Companion.getCONSOLE_INFO_KEY());
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"getConsoleViewType(...)");
                contentType.element = consoleViewContentType2;
            }
            printableEntity = new Text(text, (ConsoleViewContentType)contentType.element, null, null, 12, null);
        }
        return printableEntity;
    }

    @Override
    public void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType, boolean xmlView) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        if (value instanceof ObjectValue) {
            string = VariableViewKt.getObjectValueDescription((ObjectValue)value);
        } else {
            String string2 = value.getValueString();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String valueString = string;
        String string3 = expression;
        if (string3 == null) {
            string3 = valueString;
        }
        this.printValue((XValue)VariableViewKt.VariableView((Variable)new VariableImpl(string3, value), new VariableContext(this){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public EvaluateContext getEvaluateContext() {
                EvaluateContext evaluateContext = WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0).getEvaluateContext();
                if (evaluateContext == null) {
                    throw new IllegalStateException("global evaluation context is null, vm " + WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0) + ", vm class " + WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0).getClass().getName());
                }
                return evaluateContext;
            }

            public boolean watchableAsEvaluationExpression() {
                return false;
            }

            @NotNull
            public DebuggerViewSupport getViewSupport() {
                return this.this$0.getDebugProcess().getDebuggerViewSupport();
            }

            @NotNull
            public Vm getVm() {
                return WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0);
            }
        }), xmlView);
    }

    @Override
    public void addMessageLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Pair<HyperlinkInfo, String> pair = this.createLinkInfo(url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId);
        HyperlinkInfo hyperlinkInfo = (HyperlinkInfo)pair.component1();
        String linkText = (String)pair.component2();
        this.getTasks().add(new Function0<Unit>(this, linkText, hyperlinkInfo){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ String $linkText;
            final /* synthetic */ HyperlinkInfo $hyperlinkInfo;
            {
                this.this$0 = $receiver;
                this.$linkText = $linkText;
                this.$hyperlinkInfo = $hyperlinkInfo;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$printMessageHyperlink(this.this$0, this.$linkText, this.$hyperlinkInfo, LinkType.MESSAGE);
            }
        });
    }

    @Override
    public void addHyperLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Pair<HyperlinkInfo, String> pair = this.createLinkInfo(url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId);
        HyperlinkInfo hyperlinkInfo = (HyperlinkInfo)pair.component1();
        String linkText = (String)pair.component2();
        this.getTasks().add(new Function0<Unit>(this, linkText, hyperlinkInfo){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ String $linkText;
            final /* synthetic */ HyperlinkInfo $hyperlinkInfo;
            {
                this.this$0 = $receiver;
                this.$linkText = $linkText;
                this.$hyperlinkInfo = $hyperlinkInfo;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$printMessageHyperlink(this.this$0, this.$linkText, this.$hyperlinkInfo, LinkType.SOURCE);
            }
        });
    }

    @Override
    public void addHyperLink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkText, (String)"hyperlinkText");
        this.getTasks().add(new Function0<Unit>(this, hyperlinkText, info){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ String $hyperlinkText;
            final /* synthetic */ HyperlinkInfo $info;
            {
                this.this$0 = $receiver;
                this.$hyperlinkText = $hyperlinkText;
                this.$info = $info;
                super(0);
            }

            public final void invoke() {
                WebConsoleMessageBuilder.access$printMessageHyperlink(this.this$0, this.$hyperlinkText, this.$info, LinkType.SOURCE);
            }
        });
    }

    @Override
    public void printBrowserLink(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.getTasks().add(new Function0<Unit>(this, url){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                super(0);
            }

            public final void invoke() {
                String string = JsFileUtil.trimTitle(this.$url);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimTitle(...)");
                WebConsoleMessageBuilder.access$printMessageHyperlink(this.this$0, string, (HyperlinkInfo)new OpenUrlHyperlinkInfo(this.$url, this.this$0.getDebugProcess().getConnection().getBrowser()), LinkType.SOURCE);
            }
        });
    }

    private final void printMessageHyperlink(String hyperlinkText, HyperlinkInfo info, LinkType linkType) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        this.printer.print(new HyperLink(hyperlinkText, consoleViewContentType, info, linkType, null, 16, null));
    }

    private final Pair<HyperlinkInfo, String> createLinkInfo(String url, int suggestedLine, int suggestedColumn, String functionName, boolean resolveToScript, String scriptId) {
        int line = suggestedLine;
        int column = suggestedColumn;
        SourceInfo sourceInfo = resolveToScript ? this.getDebugProcess().getSourceInfo(this.messageVm, scriptId, url, functionName, line, column) : null;
        VirtualFile file2 = null;
        Url parsedUrl = null;
        OpenFileHyperlinkInfo hyperlinkInfo = null;
        if (sourceInfo == null) {
            parsedUrl = ScriptDebuggerUrls.parse((String)url, (boolean)true);
            VirtualFile virtualFile = file2 = parsedUrl == null ? null : JavaScriptDebugProcess.findFile$default(this.getDebugProcess(), parsedUrl, false, null, 6, null);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.getDebugProcess().getSession().getProject(), file2, 0);
                Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"createNavigatable(...)");
                Navigatable navigatable2 = navigatable;
                hyperlinkInfo = arg_0 -> WebConsoleMessageBuilder.createLinkInfo$lambda$4$lambda$3(navigatable2, arg_0);
            }
        } else {
            file2 = sourceInfo.getFile();
            line = sourceInfo.getLine();
            parsedUrl = null;
            Project project = this.getDebugProcess().getSession().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            hyperlinkInfo = new OpenFileHyperlinkInfo(sourceInfo.createNavigatable(project));
        }
        String linkText = this.getLinkText(parsedUrl, file2, url, line);
        return new Pair((Object)hyperlinkInfo, (Object)linkText);
    }

    private final String getLinkText(Url parsedUrl, VirtualFile file2, String rawUrl, int line) {
        Url url;
        Object object = file2;
        if ((object == null || (object = object.getName()) == null) && ((url = parsedUrl) != null && (url = url.trimParameters()) != null ? url.toDecodedForm() : (object = null)) == null) {
            object = rawUrl;
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        Object name = object2;
        String string = StringUtil.shortenPathWithEllipsis((String)name, (int)25, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenPathWithEllipsis(...)");
        name = string;
        return line < 0 ? name : (String)name + ":" + (line + 1);
    }

    @Override
    public void flush() {
        Iterable $this$forEach$iv = this.getTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final String printStackTrace$frameName(CallFrameValue frame) {
        CharSequence charSequence;
        CharSequence charSequence2 = frame.functionName();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "(anonymous function)";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final PrintableEntity prepareValueEntity$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PrintableEntity)$tmp0.invoke(p0);
    }

    private static final void createLinkInfo$lambda$4$lambda$3(Navigatable $navigatable, Project it) {
        Intrinsics.checkNotNullParameter((Object)$navigatable, (String)"$navigatable");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $navigatable.navigate(true);
    }

    public static final /* synthetic */ MessagePrinter access$getPrinter$p(WebConsoleMessageBuilder $this) {
        return $this.printer;
    }

    public static final /* synthetic */ WebConsoleView.DOMPresentationProvider access$getDomPresentationProvider$p(WebConsoleMessageBuilder $this) {
        return $this.domPresentationProvider;
    }

    public static final /* synthetic */ Vm access$getMessageVm$p(WebConsoleMessageBuilder $this) {
        return $this.messageVm;
    }

    public static final /* synthetic */ void access$printMessageHyperlink(WebConsoleMessageBuilder $this, String hyperlinkText, HyperlinkInfo info, LinkType linkType) {
        $this.printMessageHyperlink(hyperlinkText, info, linkType);
    }
}

