/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.browserConnection;

import com.intellij.ide.IdeBundle;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/browserConnection/IdeInfoServerHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.javascript.debugger"})
public final class IdeInfoServerHandler
extends HttpRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/browserConnection/buildInfo", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)urlDecoder.path(), (Object)"/browserConnection/buildInfo")) {
            return false;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("js-debugger-chrome-extension-used");
        String string = JSDebuggerBundle.message("js.debugger.chrome.extension.used.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = JSDebuggerBundle.message("js.debugger.chrome.extension.used.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Supplier supplier = IdeBundle.messagePointer((String)"label.dont.show", (Object[])new Object[0]);
        notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).setSuggestionType(true).addAction((AnAction)new NotificationAction(supplier){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification.expire();
                notification.setDoNotAskFor(null);
            }
        }).notify(null);
        return true;
    }
}

