/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.javascript.debugger.FunctionStepIntoVariant;
import com.intellij.javascript.debugger.LineVisitor;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/VariantsCollector;", "Lcom/intellij/javascript/debugger/LineVisitor;", "()V", "variants", "", "Lcom/intellij/javascript/debugger/FunctionStepIntoVariant;", "getVariants", "()Ljava/util/List;", "setVariants", "(Ljava/util/List;)V", "addVariant", "", "place", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "function", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "visitElement", "node", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.debugger"})
final class VariantsCollector
extends LineVisitor {
    @Nullable
    private List<FunctionStepIntoVariant> variants;

    @Nullable
    public final List<FunctionStepIntoVariant> getVariants() {
        return this.variants;
    }

    public final void setVariants(@Nullable List<FunctionStepIntoVariant> list) {
        this.variants = list;
    }

    public void visitElement(@NotNull PsiElement node) {
        PsiElement methodExpression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(node.getNode().getElementType()) && (methodExpression = node.getParent()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getParent() instanceof JSCallExpression) {
            String name;
            PsiElement function;
            Collection collection = TargetElementUtil.getInstance().getTargetCandidates((PsiReference)methodExpression);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTargetCandidates(...)");
            Collection candidates = collection;
            PsiElement psiElement = function = candidates.size() == 1 ? (PsiElement)candidates.iterator().next() : null;
            if (function instanceof JSQualifiedNamedElement && (name = ((JSQualifiedNamedElement)function).getName()) != null) {
                PsiElement psiElement2 = ((JSReferenceExpression)methodExpression).getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSCallExpression");
                this.addVariant((JSCallExpression)psiElement2, (JSQualifiedNamedElement)function);
            }
        }
        super.visitElement(node);
    }

    private final void addVariant(JSCallExpression place, JSQualifiedNamedElement function) {
        if (this.variants == null) {
            this.variants = (List)new SmartList();
        }
        List<FunctionStepIntoVariant> list = this.variants;
        Intrinsics.checkNotNull(list);
        list.add(new FunctionStepIntoVariant(place, function));
    }
}

