/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptSuspendContext;
import com.intellij.javascript.debugger.V8ValueMarkerProvider;
import com.intellij.javascript.debugger.ValueMarkersRefIds;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016H&J\u0015\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "Lcom/intellij/xdebugger/frame/XValueMarkerProvider;", "Lorg/jetbrains/debugger/VariableView;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "markedObjectExpression", "", "markers", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "nextMarker", "canMark", "", "value", "computeRefIds", "Lcom/intellij/javascript/debugger/ValueMarkersRefIds;", "computeRefIds$intellij_javascript_debugger", "getMarker", "(Lorg/jetbrains/debugger/VariableView;)Ljava/lang/Integer;", "getMarkersRefIds", "getRefId", "Lorg/jetbrains/debugger/values/Value;", "markValue", "storeMarkedValue", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "marker", "unmarkValue", "intellij.javascript.debugger"})
public abstract class V8ValueMarkerProvider
extends XValueMarkerProvider<VariableView, Integer> {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final IntOpenHashSet markers;
    private int nextMarker;
    @NotNull
    private final String markedObjectExpression;

    public V8ValueMarkerProvider(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(VariableView.class);
        this.debugProcess = debugProcess;
        this.markers = new IntOpenHashSet();
        this.markedObjectExpression = (this.debugProcess.isFilesOnlyInLocalFileSystem() ? "global" : "window") + ".__IDEA__MARKED__VALUES__";
    }

    public boolean canMark(@NotNull VariableView value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.getRefId(value.getValue()) != null && value.getEvaluationExpression() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Integer markValue(@NotNull VariableView value) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IntOpenHashSet intOpenHashSet = this.markers;
        synchronized (intOpenHashSet) {
            boolean bl = false;
            int n2 = this.nextMarker;
            this.nextMarker = n2 + 1;
            int marker = n2;
            this.markers.add(marker);
            n = marker;
        }
        int marker = n;
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        Intrinsics.checkNotNull((Object)valueMarkersRefIds);
        String string = this.getRefId(value.getValue());
        Intrinsics.checkNotNull((Object)string);
        valueMarkersRefIds.addMarker(marker, string);
        EvaluateContext evaluateContext = value.getEvaluateContext();
        String string2 = value.getEvaluationExpression();
        Intrinsics.checkNotNull((Object)string2);
        this.storeMarkedValue(evaluateContext, marker, string2);
        return marker;
    }

    @Nullable
    public Integer getMarker(@NotNull VariableView value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = this.getRefId(value.getValue());
        if (string == null) {
            return null;
        }
        String refId = string;
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        Intrinsics.checkNotNull((Object)valueMarkersRefIds);
        return valueMarkersRefIds.getMarker(refId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarkValue(@NotNull VariableView value, int marker) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        if (valueMarkersRefIds != null) {
            valueMarkersRefIds.removeMarker(marker);
        }
        IntOpenHashSet intOpenHashSet = this.markers;
        synchronized (intOpenHashSet) {
            boolean bl = false;
            boolean bl2 = this.markers.remove(marker);
        }
        this.storeMarkedValue(value.getEvaluateContext(), marker, "null");
    }

    private final ValueMarkersRefIds getMarkersRefIds() {
        XSuspendContext xSuspendContext = this.debugProcess.getSession().getSuspendContext();
        Intrinsics.checkNotNull((Object)xSuspendContext, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptSuspendContext");
        return ((JavaScriptSuspendContext)xSuspendContext).getMarkersRefIds$intellij_javascript_debugger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ValueMarkersRefIds computeRefIds$intellij_javascript_debugger() {
        int[] nArray;
        ValueMarkersRefIds refIds = new ValueMarkersRefIds();
        IntOpenHashSet intOpenHashSet = this.markers;
        synchronized (intOpenHashSet) {
            boolean bl = false;
            nArray = this.markers.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : this.markers.toIntArray();
        }
        int[] ids = nArray;
        Intrinsics.checkNotNull((Object)ids);
        if (!(ids.length == 0)) {
            Vm vm = this.debugProcess.getMainVm();
            Intrinsics.checkNotNull((Object)vm);
            EvaluateContext evaluateContext = vm.getEvaluateContext();
            Intrinsics.checkNotNull((Object)evaluateContext);
            EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)this.markedObjectExpression, null, (boolean)false, null, (int)14, null).onSuccess(arg_0 -> V8ValueMarkerProvider.computeRefIds$lambda$3((Function1)new Function1<EvaluateResult, Unit>(ids, refIds, this){
                final /* synthetic */ int[] $ids;
                final /* synthetic */ ValueMarkersRefIds $refIds;
                final /* synthetic */ V8ValueMarkerProvider this$0;
                {
                    this.$ids = $ids;
                    this.$refIds = $refIds;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(EvaluateResult it) {
                    block0: {
                        Value value = it.getValue();
                        ObjectValue objectValue = value instanceof ObjectValue ? (ObjectValue)value : null;
                        if (objectValue == null) break block0;
                        value = objectValue;
                        int[] nArray = this.$ids;
                        ValueMarkersRefIds valueMarkersRefIds = this.$refIds;
                        V8ValueMarkerProvider v8ValueMarkerProvider = this.this$0;
                        Value it2 = value;
                        boolean bl = false;
                        it2.getProperties().onSuccess(arg_0 -> computeRefIds.1.invoke$lambda$1$lambda$0((Function1)new Function1<List<? extends Variable>, Unit>(nArray, valueMarkersRefIds, v8ValueMarkerProvider){
                            final /* synthetic */ int[] $ids;
                            final /* synthetic */ ValueMarkersRefIds $refIds;
                            final /* synthetic */ V8ValueMarkerProvider this$0;
                            {
                                this.$ids = $ids;
                                this.$refIds = $refIds;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(List<? extends Variable> it) {
                                Arrays.sort(this.$ids);
                                for (Variable variable : it) {
                                    int id = StringUtil.parseInt((String)variable.getName(), (int)-1);
                                    if (id == -1 || Arrays.binarySearch(this.$ids, id) == -1) continue;
                                    String string = this.this$0.getRefId(variable.getValue());
                                    Intrinsics.checkNotNull((Object)string);
                                    this.$refIds.addMarker(id, string);
                                }
                            }
                        }, arg_0));
                    }
                }

                private static final void invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }, arg_0));
        }
        return refIds;
    }

    private final void storeMarkedValue(EvaluateContext evaluateContext, int marker, String value) {
        String expression = StringsKt.trimIndent((String)("\n    (function() {\n      var m = " + this.markedObjectExpression + ";\n      if (m == null) {\n        if (typeof WeakMap == \"undefined\") {\n          return;\n        }\n        m = new WeakMap();\n        " + this.markedObjectExpression + " = m;\n      }\n      m.set(" + value + ", " + marker + ");\n    })()\n      "));
        EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)expression, null, (boolean)false, null, (int)14, null).onError(arg_0 -> V8ValueMarkerProvider.storeMarkedValue$lambda$4(storeMarkedValue.1.INSTANCE, arg_0));
    }

    @Nullable
    public abstract String getRefId(@Nullable Value var1);

    private static final void computeRefIds$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void storeMarkedValue$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

