/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.debugger.LocalVariablesHolder;
import com.intellij.javascript.debugger.VariablesHolder;
import com.intellij.javascript.debugger.VariablesHolderKt;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandlerKt;
import com.intellij.openapi.application.ActionsKt;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "Lcom/intellij/javascript/debugger/VariablesHolder;", "vmSupplier", "Ljava/util/function/Supplier;", "Lorg/jetbrains/debugger/Vm;", "(Ljava/util/function/Supplier;)V", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "getCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "setCallFrame", "(Lorg/jetbrains/debugger/CallFrame;)V", "variablesLoader", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "", "getVariablesLoader", "()Lorg/jetbrains/concurrency/AsyncValueLoader;", "intellij.javascript.debugger"})
public final class LocalVariablesHolder
extends VariablesHolder {
    @Nullable
    private volatile CallFrame callFrame;
    @NotNull
    private final AsyncValueLoader<Boolean> variablesLoader;

    public LocalVariablesHolder(@NotNull Supplier<Vm> vmSupplier2) {
        Intrinsics.checkNotNullParameter(vmSupplier2, (String)"vmSupplier");
        this.variablesLoader = (AsyncValueLoader)new AsyncValueLoader<Boolean>(this, vmSupplier2){
            final /* synthetic */ LocalVariablesHolder this$0;
            final /* synthetic */ Supplier<Vm> $vmSupplier;
            {
                this.this$0 = $receiver;
                this.$vmSupplier = $vmSupplier;
            }

            @NotNull
            protected Promise<Boolean> load(@NotNull AsyncPromise<Boolean> promise2) {
                Intrinsics.checkNotNullParameter(promise2, (String)"promise");
                CallFrame currentCallFrame = this.this$0.getCallFrame();
                if (currentCallFrame == null) {
                    promise2.cancel();
                    return (Promise)promise2;
                }
                Scope scope = JavaScriptDebuggerConsoleExecuteActionHandlerKt.getLocalScope(currentCallFrame);
                if (scope == null) {
                    promise2.cancel();
                    return (Promise)promise2;
                }
                Promise promise3 = scope.getVariablesHost().get().then(arg_0 -> variablesLoader.1.load$lambda$0((Function1)new Function1<List<Variable>, Boolean>(this.$vmSupplier, this.this$0){
                    final /* synthetic */ Supplier<Vm> $vmSupplier;
                    final /* synthetic */ LocalVariablesHolder this$0;
                    {
                        this.$vmSupplier = $vmSupplier;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Boolean invoke(List<Variable> variables) {
                        if (this.$vmSupplier.get() == null || variables.isEmpty()) {
                            return true;
                        }
                        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this.this$0, variables){
                            final /* synthetic */ LocalVariablesHolder this$0;
                            final /* synthetic */ List<Variable> $variables;
                            {
                                this.this$0 = $receiver;
                                this.$variables = $variables;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getNameToPsiTypeName().clear();
                                this.this$0.getLookupElements().clear();
                                this.this$0.getLookupElements().ensureCapacity(this.$variables.size());
                                for (Variable variable : this.$variables) {
                                    LookupElementBuilder lookupItem;
                                    String name;
                                    Intrinsics.checkNotNullExpressionValue((Object)variable.getName(), (String)"getName(...)");
                                    String string = VariablesHolderKt.backendTypeNameToPsiTypeName(variable.getValue());
                                    if (string == null) continue;
                                    this.this$0.getNameToPsiTypeName().put(name, string);
                                    Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)name), (String)"create(...)");
                                    if (variable.getValue() != null) {
                                        Value it;
                                        boolean bl = false;
                                        lookupItem.withIcon(VariableView.Companion.getIcon(it));
                                    }
                                    this.this$0.getLookupElements().add((LookupElement)lookupItem);
                                }
                            }
                        }));
                        return true;
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"then(...)");
                return promise3;
            }

            private static final Boolean load$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    @Nullable
    public final CallFrame getCallFrame() {
        return this.callFrame;
    }

    public final void setCallFrame(@Nullable CallFrame callFrame) {
        this.callFrame = callFrame;
    }

    @NotNull
    protected AsyncValueLoader<Boolean> getVariablesLoader() {
        return this.variablesLoader;
    }
}

