/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "()V", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteUrls", "", "file", "intellij.javascript.debugger"})
public class LocalFileSystemFileFinder
implements DebuggableFileFinder {
    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        String projectBasePath;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        if (!OSAgnosticPathUtil.isAbsolute((String)path)) {
            return null;
        }
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
        if (file2 == null && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((String)projectBasePath, (String)path, (boolean)true)) {
            file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
        VirtualFile virtualFile3 = file2;
        if (virtualFile3 != null) {
            VirtualFile it = virtualFile3;
            boolean bl = false;
            virtualFile2 = (VirtualFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>(project, it){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $it;
                {
                    this.$project = $project;
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final VirtualFile invoke() {
                    return ProjectRootUtil.findSymlinkedFileInContent((Project)this.$project, (VirtualFile)this.$it);
                }
            }));
        } else {
            virtualFile2 = null;
        }
        if ((virtualFile = (file2 = virtualFile2)) == null) {
            virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(path, project);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return CollectionsKt.listOf((Object)ScriptDebuggerUrls.newLocalFileUrl((String)string));
    }
}

