/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.BaseCollector;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.SourceInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J(\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u0006R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068D@BX\u0084\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108D@BX\u0084\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/debugger/LineVisitor;", "Lorg/jetbrains/debugger/PsiVisitors$Visitor;", "", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "()V", "<set-?>", "Lcom/intellij/openapi/editor/Document;", "document", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "setDocument", "(Lcom/intellij/openapi/editor/Document;)V", "document$delegate", "Lkotlin/properties/ReadWriteProperty;", "isStopped", "", "Lcom/intellij/xdebugger/XSourcePosition;", "position", "getPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "setPosition", "(Lcom/intellij/xdebugger/XSourcePosition;)V", "position$delegate", "createSourcePosition", "Lorg/jetbrains/debugger/SourceInfo;", "element", "Lcom/intellij/psi/PsiElement;", "visit", "elementAtStart", "positionOffset", "", "intellij.javascript.debugger"})
public abstract class LineVisitor
extends JSElementVisitor
implements PsiVisitors.Visitor<Object> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadWriteProperty document$delegate = Delegates.INSTANCE.notNull();
    @NotNull
    private final ReadWriteProperty position$delegate = Delegates.INSTANCE.notNull();
    @JvmField
    protected boolean isStopped;

    @NotNull
    protected final Document getDocument() {
        return (Document)this.document$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setDocument(Document document) {
        this.document$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)document);
    }

    @NotNull
    protected final XSourcePosition getPosition() {
        return (XSourcePosition)this.position$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setPosition(XSourcePosition xSourcePosition) {
        this.position$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)xSourcePosition);
    }

    @NotNull
    protected final SourceInfo createSourcePosition(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XSourcePosition linePosition = this.getPosition();
        int offset = element.getTextOffset();
        VirtualFile virtualFile = linePosition.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return new SourceInfo(virtualFile, linePosition.getLine(), offset - this.getDocument().getLineStartOffset(linePosition.getLine()), offset, null, null, 48, null);
    }

    @Nullable
    public final Object visit(@NotNull XSourcePosition position, @NotNull PsiElement elementAtStart, int positionOffset, @NotNull Document document) {
        PsiElement topmostPossibleParent;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)elementAtStart, (String)"elementAtStart");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.setDocument(document);
        this.setPosition(position);
        int end = document.getLineEndOffset(position.getLine());
        for (topmostPossibleParent = elementAtStart; !(topmostPossibleParent == null || topmostPossibleParent instanceof PsiFile || topmostPossibleParent.getNode().getStartOffset() < positionOffset && topmostPossibleParent.getNode().getTextRange().getEndOffset() > end); topmostPossibleParent = topmostPossibleParent.getParent()) {
        }
        if (topmostPossibleParent != null) {
            topmostPossibleParent.acceptChildren((PsiElementVisitor)new BaseCollector(this, positionOffset, end){
                final /* synthetic */ LineVisitor this$0;
                final /* synthetic */ int $positionOffset;
                final /* synthetic */ int $end;
                {
                    this.this$0 = $receiver;
                    this.$positionOffset = $positionOffset;
                    this.$end = $end;
                }

                private final boolean process(PsiElement element) {
                    if (this.this$0.isStopped) {
                        return false;
                    }
                    TextRange range = element.getNode().getTextRange();
                    if (range.getEndOffset() <= this.$positionOffset || range.getStartOffset() >= this.$end) {
                        return false;
                    }
                    if (range.getStartOffset() >= this.$positionOffset) {
                        element.accept((PsiElementVisitor)this.this$0);
                    }
                    return true;
                }

                public void visitJSReturnStatement(@NotNull JSReturnStatement element) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        if (!this.process((PsiElement)element)) break block1;
                        JSExpression jSExpression = element.getExpression();
                        if (jSExpression != null) {
                            JSExpression it = jSExpression;
                            boolean bl = false;
                            super.visitElement((PsiElement)it);
                        }
                    }
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (this.process(element)) {
                        super.visitElement(element);
                    }
                }
            });
        }
        return null;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(LineVisitor.class, "document", "getDocument()Lcom/intellij/openapi/editor/Document;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(LineVisitor.class, "position", "getPosition()Lcom/intellij/xdebugger/XSourcePosition;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

