/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0003"}, d2={"Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "", "canSetRemoteUrl", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findFile", "url", "Lcom/intellij/util/Url;", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "getRemoteUrls", "", "guessFile", "isOnlySourceMappedBreakpoints", "searchesByName", "intellij.javascript.debugger"})
public interface DebuggableFileFinder {
    @Nullable
    default public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @Nullable
    default public VirtualFile guessFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    default public boolean searchesByName() {
        return false;
    }

    @Nullable
    default public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    default public boolean canSetRemoteUrl(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile var1);

    default public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileType fileType = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        JavaScriptDebugAware debugAware = JavaScriptDebugAware.Companion.getBreakpointAware(fileType);
        return debugAware != null && debugAware.isOnlySourceMappedBreakpoints();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static VirtualFile findFile(@NotNull DebuggableFileFinder $this, @NotNull Url url, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return $this.findFile(url, project);
        }

        @Deprecated
        @Nullable
        public static VirtualFile guessFile(@NotNull DebuggableFileFinder $this, @NotNull Url url, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return $this.guessFile(url, project);
        }

        @Deprecated
        public static boolean searchesByName(@NotNull DebuggableFileFinder $this) {
            return $this.searchesByName();
        }

        @Deprecated
        @Nullable
        public static Navigatable findNavigatable(@NotNull DebuggableFileFinder $this, @NotNull Url url, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return $this.findNavigatable(url, project);
        }

        @Deprecated
        public static boolean canSetRemoteUrl(@NotNull DebuggableFileFinder $this, @NotNull VirtualFile file2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return $this.canSetRemoteUrl(file2, project);
        }

        @Deprecated
        public static boolean isOnlySourceMappedBreakpoints(@NotNull DebuggableFileFinder $this, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return $this.isOnlySourceMappedBreakpoints(file2);
        }
    }
}

