/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.math.DD;

public class TrianglePredicate {
    public static boolean isInCircleNonRobust(Coordinate a, Coordinate b2, Coordinate c2, Coordinate p2) {
        boolean isInCircle = (a.x * a.x + a.y * a.y) * TrianglePredicate.triArea(b2, c2, p2) - (b2.x * b2.x + b2.y * b2.y) * TrianglePredicate.triArea(a, c2, p2) + (c2.x * c2.x + c2.y * c2.y) * TrianglePredicate.triArea(a, b2, p2) - (p2.x * p2.x + p2.y * p2.y) * TrianglePredicate.triArea(a, b2, c2) > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleNormalized(Coordinate a, Coordinate b2, Coordinate c2, Coordinate p2) {
        double adx = a.x - p2.x;
        double ady = a.y - p2.y;
        double alift = adx * adx + ady * ady;
        double bdx = b2.x - p2.x;
        double cdy = c2.y - p2.y;
        double cdx = c2.x - p2.x;
        double bdy = b2.y - p2.y;
        double bcdet = bdx * cdy - cdx * bdy;
        double blift = bdx * bdx + bdy * bdy;
        double cadet = cdx * ady - adx * cdy;
        double clift = cdx * cdx + cdy * cdy;
        double abdet = adx * bdy - bdx * ady;
        double disc = alift * bcdet + blift * cadet + clift * abdet;
        return disc > 0.0;
    }

    private static double triArea(Coordinate a, Coordinate b2, Coordinate c2) {
        return (b2.x - a.x) * (c2.y - a.y) - (b2.y - a.y) * (c2.x - a.x);
    }

    public static boolean isInCircleRobust(Coordinate a, Coordinate b2, Coordinate c2, Coordinate p2) {
        return TrianglePredicate.isInCircleNormalized(a, b2, c2, p2);
    }

    public static boolean isInCircleDDSlow(Coordinate a, Coordinate b2, Coordinate c2, Coordinate p2) {
        DD px = DD.valueOf(p2.x);
        DD py = DD.valueOf(p2.y);
        DD ax = DD.valueOf(a.x);
        DD ay = DD.valueOf(a.y);
        DD bx = DD.valueOf(b2.x);
        DD by = DD.valueOf(b2.y);
        DD cx = DD.valueOf(c2.x);
        DD cy = DD.valueOf(c2.y);
        DD aTerm = ax.multiply(ax).add(ay.multiply(ay)).multiply(TrianglePredicate.triAreaDDSlow(bx, by, cx, cy, px, py));
        DD bTerm = bx.multiply(bx).add(by.multiply(by)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, cx, cy, px, py));
        DD cTerm = cx.multiply(cx).add(cy.multiply(cy)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, bx, by, px, py));
        DD pTerm = px.multiply(px).add(py.multiply(py)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, bx, by, cx, cy));
        DD sum2 = aTerm.subtract(bTerm).add(cTerm).subtract(pTerm);
        boolean isInCircle = sum2.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDSlow(DD ax, DD ay, DD bx, DD by, DD cx, DD cy) {
        return bx.subtract(ax).multiply(cy.subtract(ay)).subtract(by.subtract(ay).multiply(cx.subtract(ax)));
    }

    public static boolean isInCircleDDFast(Coordinate a, Coordinate b2, Coordinate c2, Coordinate p2) {
        DD aTerm = DD.sqr(a.x).selfAdd(DD.sqr(a.y)).selfMultiply(TrianglePredicate.triAreaDDFast(b2, c2, p2));
        DD bTerm = DD.sqr(b2.x).selfAdd(DD.sqr(b2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, c2, p2));
        DD cTerm = DD.sqr(c2.x).selfAdd(DD.sqr(c2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, b2, p2));
        DD pTerm = DD.sqr(p2.x).selfAdd(DD.sqr(p2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, b2, c2));
        DD sum2 = aTerm.selfSubtract(bTerm).selfAdd(cTerm).selfSubtract(pTerm);
        boolean isInCircle = sum2.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDFast(Coordinate a, Coordinate b2, Coordinate c2) {
        DD t1 = DD.valueOf(b2.x).selfSubtract(a.x).selfMultiply(DD.valueOf(c2.y).selfSubtract(a.y));
        DD t2 = DD.valueOf(b2.y).selfSubtract(a.y).selfMultiply(DD.valueOf(c2.x).selfSubtract(a.x));
        return t1.selfSubtract(t2);
    }

    public static boolean isInCircleDDNormalized(Coordinate a, Coordinate b2, Coordinate c2, Coordinate p2) {
        DD adx = DD.valueOf(a.x).selfSubtract(p2.x);
        DD ady = DD.valueOf(a.y).selfSubtract(p2.y);
        DD bdx = DD.valueOf(b2.x).selfSubtract(p2.x);
        DD bdy = DD.valueOf(b2.y).selfSubtract(p2.y);
        DD cdx = DD.valueOf(c2.x).selfSubtract(p2.x);
        DD cdy = DD.valueOf(c2.y).selfSubtract(p2.y);
        DD abdet = adx.multiply(bdy).selfSubtract(bdx.multiply(ady));
        DD bcdet = bdx.multiply(cdy).selfSubtract(cdx.multiply(bdy));
        DD cadet = cdx.multiply(ady).selfSubtract(adx.multiply(cdy));
        DD alift = adx.multiply(adx).selfAdd(ady.multiply(ady));
        DD blift = bdx.multiply(bdx).selfAdd(bdy.multiply(bdy));
        DD clift = cdx.multiply(cdx).selfAdd(cdy.multiply(cdy));
        DD sum2 = alift.selfMultiply(bcdet).selfAdd(blift.selfMultiply(cadet)).selfAdd(clift.selfMultiply(abdet));
        boolean isInCircle = sum2.doubleValue() > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleCC(Coordinate a, Coordinate b2, Coordinate c2, Coordinate p2) {
        Coordinate cc = Triangle.circumcentre(a, b2, c2);
        double ccRadius = a.distance(cc);
        double pRadiusDiff = p2.distance(cc) - ccRadius;
        return pRadiusDiff <= 0.0;
    }
}

