/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.simplify.DouglasPeuckerLineSimplifier;

public class DouglasPeuckerSimplifier {
    private Geometry inputGeom;
    private double distanceTolerance;
    private boolean isEnsureValidTopology = true;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        DouglasPeuckerSimplifier tss = new DouglasPeuckerSimplifier(geom);
        tss.setDistanceTolerance(distanceTolerance);
        return tss.getResultGeometry();
    }

    public DouglasPeuckerSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public void setEnsureValid(boolean isEnsureValidTopology) {
        this.isEnsureValidTopology = isEnsureValidTopology;
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return this.inputGeom.copy();
        }
        return new DPTransformer(this.isEnsureValidTopology, this.distanceTolerance).transform(this.inputGeom);
    }

    static class DPTransformer
    extends GeometryTransformer {
        private boolean isEnsureValidTopology = true;
        private double distanceTolerance;

        public DPTransformer(boolean isEnsureValidTopology, double distanceTolerance) {
            this.isEnsureValidTopology = isEnsureValidTopology;
            this.distanceTolerance = distanceTolerance;
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent2) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = null;
            newPts = inputPts.length == 0 ? new Coordinate[]{} : DouglasPeuckerLineSimplifier.simplify(inputPts, this.distanceTolerance);
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        @Override
        protected Geometry transformPolygon(Polygon geom, Geometry parent2) {
            if (geom.isEmpty()) {
                return null;
            }
            Geometry rawGeom = super.transformPolygon(geom, parent2);
            if (parent2 instanceof MultiPolygon) {
                return rawGeom;
            }
            return this.createValidArea(rawGeom);
        }

        @Override
        protected Geometry transformLinearRing(LinearRing geom, Geometry parent2) {
            boolean removeDegenerateRings = parent2 instanceof Polygon;
            Geometry simpResult = super.transformLinearRing(geom, parent2);
            if (removeDegenerateRings && !(simpResult instanceof LinearRing)) {
                return null;
            }
            return simpResult;
        }

        @Override
        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent2) {
            Geometry rawGeom = super.transformMultiPolygon(geom, parent2);
            return this.createValidArea(rawGeom);
        }

        private Geometry createValidArea(Geometry rawAreaGeom) {
            boolean isValidArea;
            boolean bl = isValidArea = rawAreaGeom.getDimension() == 2 && rawAreaGeom.isValid();
            if (this.isEnsureValidTopology && !isValidArea) {
                return rawAreaGeom.buffer(0.0);
            }
            return rawAreaGeom;
        }
    }
}

