/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import org.locationtech.jts.geom.Coordinate;

public class HilbertCode {
    public static final int MAX_LEVEL = 16;

    public static int size(int level) {
        HilbertCode.checkLevel(level);
        return (int)Math.pow(2.0, 2 * level);
    }

    public static int maxOrdinate(int level) {
        HilbertCode.checkLevel(level);
        return (int)Math.pow(2.0, level) - 1;
    }

    public static int level(int numPoints) {
        int pow2 = (int)(Math.log(numPoints) / Math.log(2.0));
        int level = pow2 / 2;
        int size = HilbertCode.size(level);
        if (size < numPoints) {
            ++level;
        }
        return level;
    }

    private static void checkLevel(int level) {
        if (level > 16) {
            throw new IllegalArgumentException("Level must be in range 0 to 16");
        }
    }

    public static int encode(int level, int x, int y) {
        int lvl = HilbertCode.levelClamp(level);
        long a = (x <<= 16 - lvl) ^ (y <<= 16 - lvl);
        long b2 = 0xFFFFL ^ a;
        long c2 = 0xFFFF ^ (x | y);
        long d2 = x & (y ^ 0xFFFF);
        long A = a | b2 >> 1;
        long B = a >> 1 ^ a;
        long C = c2 >> 1 ^ b2 & d2 >> 1 ^ c2;
        long D = a & c2 >> 1 ^ d2 >> 1 ^ d2;
        a = A;
        b2 = B;
        c2 = C;
        d2 = D;
        A = a & a >> 2 ^ b2 & b2 >> 2;
        B = a & b2 >> 2 ^ b2 & (a ^ b2) >> 2;
        C ^= a & c2 >> 2 ^ b2 & d2 >> 2;
        D ^= b2 & c2 >> 2 ^ (a ^ b2) & d2 >> 2;
        a = A;
        b2 = B;
        c2 = C;
        d2 = D;
        A = a & a >> 4 ^ b2 & b2 >> 4;
        B = a & b2 >> 4 ^ b2 & (a ^ b2) >> 4;
        C ^= a & c2 >> 4 ^ b2 & d2 >> 4;
        D ^= b2 & c2 >> 4 ^ (a ^ b2) & d2 >> 4;
        a = A;
        b2 = B;
        c2 = C;
        d2 = D;
        C ^= a & c2 >> 8 ^ b2 & d2 >> 8;
        D ^= b2 & c2 >> 8 ^ (a ^ b2) & d2 >> 8;
        a = C ^ C >> 1;
        b2 = D ^ D >> 1;
        long i0 = x ^ y;
        long i1 = b2 | 0xFFFFL ^ (i0 | a);
        i0 = (i0 | i0 << 8) & 0xFF00FFL;
        i0 = (i0 | i0 << 4) & 0xF0F0F0FL;
        i0 = (i0 | i0 << 2) & 0x33333333L;
        i0 = (i0 | i0 << 1) & 0x55555555L;
        i1 = (i1 | i1 << 8) & 0xFF00FFL;
        i1 = (i1 | i1 << 4) & 0xF0F0F0FL;
        i1 = (i1 | i1 << 2) & 0x33333333L;
        i1 = (i1 | i1 << 1) & 0x55555555L;
        long index2 = (i1 << 1 | i0) >> 32 - 2 * lvl;
        return (int)index2;
    }

    private static int levelClamp(int level) {
        int lvl = level < 1 ? 1 : level;
        lvl = lvl > 16 ? 16 : lvl;
        return lvl;
    }

    public static Coordinate decode(int level, int index2) {
        HilbertCode.checkLevel(level);
        int lvl = HilbertCode.levelClamp(level);
        long i0 = HilbertCode.deinterleave(index2 <<= 32 - 2 * lvl);
        long i1 = HilbertCode.deinterleave(index2 >> 1);
        long t0 = (i0 | i1) ^ 0xFFFFL;
        long t1 = i0 & i1;
        long prefixT0 = HilbertCode.prefixScan(t0);
        long prefixT1 = HilbertCode.prefixScan(t1);
        long a = (i0 ^ 0xFFFFL) & prefixT1 | i0 & prefixT0;
        long x = (a ^ i1) >> 16 - lvl;
        long y = (a ^ i0 ^ i1) >> 16 - lvl;
        return new Coordinate(x, y);
    }

    private static long prefixScan(long x) {
        x = x >> 8 ^ x;
        x = x >> 4 ^ x;
        x = x >> 2 ^ x;
        x = x >> 1 ^ x;
        return x;
    }

    private static long deinterleave(int x) {
        x &= 0x55555555;
        x = (x | x >> 1) & 0x33333333;
        x = (x | x >> 2) & 0xF0F0F0F;
        x = (x | x >> 4) & 0xFF00FF;
        x = (x | x >> 8) & 0xFFFF;
        return x;
    }
}

