/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.operation.overlayng.PrecisionReducer;

class PrecisionReducerTransformer
extends GeometryTransformer {
    private PrecisionModel targetPM;
    private boolean isRemoveCollapsed = false;

    public static Geometry reduce(Geometry geom, PrecisionModel targetPM, boolean isRemoveCollapsed) {
        PrecisionReducerTransformer trans = new PrecisionReducerTransformer(targetPM, isRemoveCollapsed);
        return trans.transform(geom);
    }

    PrecisionReducerTransformer(PrecisionModel targetPM, boolean isRemoveCollapsed) {
        this.targetPM = targetPM;
        this.isRemoveCollapsed = isRemoveCollapsed;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinates, Geometry parent2) {
        if (coordinates.size() == 0) {
            return null;
        }
        Coordinate[] coordsReduce = this.reduceCompress(coordinates);
        int minSize = 0;
        if (parent2 instanceof LineString) {
            minSize = 2;
        }
        if (parent2 instanceof LinearRing) {
            minSize = 3;
        }
        if (coordsReduce.length < minSize) {
            if (this.isRemoveCollapsed) {
                return null;
            }
            coordsReduce = this.extend(coordsReduce, minSize);
        }
        return this.factory.getCoordinateSequenceFactory().create(coordsReduce);
    }

    private Coordinate[] extend(Coordinate[] coords, int minLength) {
        if (coords.length >= minLength) {
            return coords;
        }
        Coordinate[] exCoords = new Coordinate[minLength];
        for (int i2 = 0; i2 < exCoords.length; ++i2) {
            int iSrc = i2 < coords.length ? i2 : coords.length - 1;
            exCoords[i2] = coords[iSrc].copy();
        }
        return exCoords;
    }

    private Coordinate[] reduceCompress(CoordinateSequence coordinates) {
        CoordinateList noRepeatCoordList = new CoordinateList();
        for (int i2 = 0; i2 < coordinates.size(); ++i2) {
            Coordinate coord = coordinates.getCoordinate(i2).copy();
            this.targetPM.makePrecise(coord);
            noRepeatCoordList.add(coord, false);
        }
        Coordinate[] noRepeatCoords = noRepeatCoordList.toCoordinateArray();
        return noRepeatCoords;
    }

    @Override
    protected Geometry transformPolygon(Polygon geom, Geometry parent2) {
        return this.reduceArea(geom);
    }

    @Override
    protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent2) {
        return this.reduceArea(geom);
    }

    private Geometry reduceArea(Geometry geom) {
        Geometry reduced = PrecisionReducer.reducePrecision(geom, this.targetPM);
        return reduced;
    }
}

