/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.PlanarGraph;
import org.locationtech.jts.planargraph.Subgraph;

public class ConnectedSubgraphFinder {
    private PlanarGraph graph;

    public ConnectedSubgraphFinder(PlanarGraph graph2) {
        this.graph = graph2;
    }

    public List getConnectedSubgraphs() {
        ArrayList<Subgraph> subgraphs = new ArrayList<Subgraph>();
        GraphComponent.setVisited(this.graph.nodeIterator(), false);
        Iterator i2 = this.graph.edgeIterator();
        while (i2.hasNext()) {
            Edge e2 = (Edge)i2.next();
            Node node2 = e2.getDirEdge(0).getFromNode();
            if (node2.isVisited()) continue;
            subgraphs.add(this.findSubgraph(node2));
        }
        return subgraphs;
    }

    private Subgraph findSubgraph(Node node2) {
        Subgraph subgraph = new Subgraph(this.graph);
        this.addReachable(node2, subgraph);
        return subgraph;
    }

    private void addReachable(Node startNode, Subgraph subgraph) {
        Stack<Node> nodeStack = new Stack<Node>();
        nodeStack.add(startNode);
        while (!nodeStack.empty()) {
            Node node2 = (Node)nodeStack.pop();
            this.addEdges(node2, nodeStack, subgraph);
        }
    }

    private void addEdges(Node node2, Stack nodeStack, Subgraph subgraph) {
        node2.setVisited(true);
        Iterator<DirectedEdge> i2 = node2.getOutEdges().iterator();
        while (i2.hasNext()) {
            DirectedEdge de = i2.next();
            subgraph.add(de.getEdge());
            Node toNode = de.getToNode();
            if (toNode.isVisited()) continue;
            nodeStack.push(toNode);
        }
    }
}

