/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.operation.valid.PolygonRingSelfNode;
import org.locationtech.jts.operation.valid.PolygonRingTouch;

class PolygonRing {
    private int id;
    private PolygonRing shell;
    private LinearRing ring;
    private PolygonRing touchSetRoot = null;
    private Map<Integer, PolygonRingTouch> touches = null;
    private ArrayList<PolygonRingSelfNode> selfNodes = null;

    public static boolean isShell(PolygonRing polyRing) {
        if (polyRing == null) {
            return true;
        }
        return polyRing.isShell();
    }

    public static boolean addTouch(PolygonRing ring0, PolygonRing ring1, Coordinate pt) {
        if (ring0 == null || ring1 == null) {
            return false;
        }
        if (!ring0.isSamePolygon(ring1)) {
            return false;
        }
        if (!ring0.isOnlyTouch(ring1, pt)) {
            return true;
        }
        if (!ring1.isOnlyTouch(ring0, pt)) {
            return true;
        }
        ring0.addTouch(ring1, pt);
        ring1.addTouch(ring0, pt);
        return false;
    }

    public static Coordinate findHoleCycleLocation(List<PolygonRing> polyRings) {
        for (PolygonRing polyRing : polyRings) {
            Coordinate holeCycleLoc;
            if (polyRing.isInTouchSet() || (holeCycleLoc = polyRing.findHoleCycleLocation()) == null) continue;
            return holeCycleLoc;
        }
        return null;
    }

    public static Coordinate findInteriorSelfNode(List<PolygonRing> polyRings) {
        for (PolygonRing polyRing : polyRings) {
            Coordinate interiorSelfNode = polyRing.findInteriorSelfNode();
            if (interiorSelfNode == null) continue;
            return interiorSelfNode;
        }
        return null;
    }

    public PolygonRing(LinearRing ring) {
        this.ring = ring;
        this.id = -1;
        this.shell = this;
    }

    public PolygonRing(LinearRing ring, int index2, PolygonRing shell) {
        this.ring = ring;
        this.id = index2;
        this.shell = shell;
    }

    public boolean isSamePolygon(PolygonRing ring) {
        return this.shell == ring.shell;
    }

    public boolean isShell() {
        return this.shell == this;
    }

    private boolean isInTouchSet() {
        return this.touchSetRoot != null;
    }

    private void setTouchSetRoot(PolygonRing ring) {
        this.touchSetRoot = ring;
    }

    private PolygonRing getTouchSetRoot() {
        return this.touchSetRoot;
    }

    private boolean hasTouches() {
        return this.touches != null && !this.touches.isEmpty();
    }

    private Collection<PolygonRingTouch> getTouches() {
        return this.touches.values();
    }

    private void addTouch(PolygonRing ring, Coordinate pt) {
        PolygonRingTouch touch;
        if (this.touches == null) {
            this.touches = new HashMap<Integer, PolygonRingTouch>();
        }
        if ((touch = this.touches.get(ring.id)) == null) {
            this.touches.put(ring.id, new PolygonRingTouch(ring, pt));
        }
    }

    public void addSelfTouch(Coordinate origin, Coordinate e00, Coordinate e01, Coordinate e10, Coordinate e11) {
        if (this.selfNodes == null) {
            this.selfNodes = new ArrayList();
        }
        this.selfNodes.add(new PolygonRingSelfNode(origin, e00, e01, e10, e11));
    }

    private boolean isOnlyTouch(PolygonRing ring, Coordinate pt) {
        if (this.touches == null) {
            return true;
        }
        PolygonRingTouch touch = this.touches.get(ring.id);
        if (touch == null) {
            return true;
        }
        return touch.isAtLocation(pt);
    }

    private Coordinate findHoleCycleLocation() {
        if (this.isInTouchSet()) {
            return null;
        }
        PolygonRing root2 = this;
        root2.setTouchSetRoot(root2);
        if (!this.hasTouches()) {
            return null;
        }
        ArrayDeque<PolygonRingTouch> touchStack = new ArrayDeque<PolygonRingTouch>();
        PolygonRing.init(root2, touchStack);
        while (!touchStack.isEmpty()) {
            PolygonRingTouch touch = (PolygonRingTouch)touchStack.pop();
            Coordinate holeCyclePt = this.scanForHoleCycle(touch, root2, touchStack);
            if (holeCyclePt == null) continue;
            return holeCyclePt;
        }
        return null;
    }

    private static void init(PolygonRing root2, Deque<PolygonRingTouch> touchStack) {
        for (PolygonRingTouch touch : root2.getTouches()) {
            touch.getRing().setTouchSetRoot(root2);
            touchStack.push(touch);
        }
    }

    private Coordinate scanForHoleCycle(PolygonRingTouch currentTouch, PolygonRing root2, Deque<PolygonRingTouch> touchStack) {
        PolygonRing ring = currentTouch.getRing();
        Coordinate currentPt = currentTouch.getCoordinate();
        for (PolygonRingTouch touch : ring.getTouches()) {
            if (currentPt.equals2D(touch.getCoordinate())) continue;
            PolygonRing touchRing = touch.getRing();
            if (touchRing.getTouchSetRoot() == root2) {
                return touch.getCoordinate();
            }
            touchRing.setTouchSetRoot(root2);
            touchStack.push(touch);
        }
        return null;
    }

    public Coordinate findInteriorSelfNode() {
        if (this.selfNodes == null) {
            return null;
        }
        boolean isCCW = Orientation.isCCW(this.ring.getCoordinates());
        boolean isInteriorOnRight = this.isShell() ^ isCCW;
        for (PolygonRingSelfNode selfNode : this.selfNodes) {
            if (selfNode.isExterior(isInteriorOnRight)) continue;
            return selfNode.getCoordinate();
        }
        return null;
    }

    public String toString() {
        return this.ring.toString();
    }
}

