/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.union.UnionStrategy;
import org.locationtech.jts.util.Debug;

public class CascadedPolygonUnion {
    static final UnionStrategy CLASSIC_UNION = new UnionStrategy(){

        @Override
        public Geometry union(Geometry g0, Geometry g1) {
            try {
                return SnapIfNeededOverlayOp.union(g0, g1);
            }
            catch (TopologyException ex) {
                return OverlayNGRobust.overlay(g0, g1, 2);
            }
        }

        @Override
        public boolean isFloatingPrecision() {
            return true;
        }
    };
    private Collection inputPolys;
    private GeometryFactory geomFactory = null;
    private UnionStrategy unionFun;
    private int countRemainder = 0;
    private int countInput = 0;
    private static final int STRTREE_NODE_CAPACITY = 4;

    public static Geometry union(Collection polys) {
        CascadedPolygonUnion op = new CascadedPolygonUnion(polys);
        return op.union();
    }

    public static Geometry union(Collection polys, UnionStrategy unionFun) {
        CascadedPolygonUnion op = new CascadedPolygonUnion(polys, unionFun);
        return op.union();
    }

    public CascadedPolygonUnion(Collection polys) {
        this(polys, CLASSIC_UNION);
    }

    public CascadedPolygonUnion(Collection polys, UnionStrategy unionFun) {
        this.inputPolys = polys;
        this.unionFun = unionFun;
        if (this.inputPolys == null) {
            this.inputPolys = new ArrayList();
        }
        this.countRemainder = this.countInput = this.inputPolys.size();
    }

    public Geometry union() {
        if (this.inputPolys == null) {
            throw new IllegalStateException("union() method cannot be called twice");
        }
        if (this.inputPolys.isEmpty()) {
            return null;
        }
        this.geomFactory = ((Geometry)this.inputPolys.iterator().next()).getFactory();
        STRtree index2 = new STRtree(4);
        for (Geometry item : this.inputPolys) {
            index2.insert(item.getEnvelopeInternal(), (Object)item);
        }
        this.inputPolys = null;
        List itemTree = index2.itemsTree();
        Geometry unionAll = this.unionTree(itemTree);
        return unionAll;
    }

    private Geometry unionTree(List geomTree) {
        List geoms = this.reduceToGeometries(geomTree);
        Geometry union = this.binaryUnion(geoms);
        return union;
    }

    private Geometry binaryUnion(List geoms) {
        return this.binaryUnion(geoms, 0, geoms.size());
    }

    private Geometry binaryUnion(List geoms, int start2, int end) {
        if (end - start2 <= 1) {
            Geometry g0 = CascadedPolygonUnion.getGeometry(geoms, start2);
            return this.unionSafe(g0, null);
        }
        if (end - start2 == 2) {
            return this.unionSafe(CascadedPolygonUnion.getGeometry(geoms, start2), CascadedPolygonUnion.getGeometry(geoms, start2 + 1));
        }
        int mid = (end + start2) / 2;
        Geometry g0 = this.binaryUnion(geoms, start2, mid);
        Geometry g1 = this.binaryUnion(geoms, mid, end);
        return this.unionSafe(g0, g1);
    }

    private static Geometry getGeometry(List list, int index2) {
        if (index2 >= list.size()) {
            return null;
        }
        return (Geometry)list.get(index2);
    }

    private List reduceToGeometries(List geomTree) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (Object o2 : geomTree) {
            Geometry geom = null;
            if (o2 instanceof List) {
                geom = this.unionTree((List)o2);
            } else if (o2 instanceof Geometry) {
                geom = (Geometry)o2;
            }
            geoms.add(geom);
        }
        return geoms;
    }

    private Geometry unionSafe(Geometry g0, Geometry g1) {
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g0 == null) {
            return g1.copy();
        }
        if (g1 == null) {
            return g0.copy();
        }
        --this.countRemainder;
        if (Debug.isDebugging()) {
            Debug.println("Remainder: " + this.countRemainder + " out of " + this.countInput);
            Debug.print("Union: A: " + g0.getNumPoints() + " / B: " + g1.getNumPoints() + "  ---  ");
        }
        Geometry union = this.unionActual(g0, g1);
        if (Debug.isDebugging()) {
            Debug.println(" Result: " + union.getNumPoints());
        }
        return union;
    }

    private Geometry unionActual(Geometry g0, Geometry g1) {
        Geometry union = this.unionFun.union(g0, g1);
        Geometry unionPoly = CascadedPolygonUnion.restrictToPolygons(union);
        return unionPoly;
    }

    private static Geometry restrictToPolygons(Geometry g2) {
        if (g2 instanceof Polygonal) {
            return g2;
        }
        List polygons = PolygonExtracter.getPolygons(g2);
        if (polygons.size() == 1) {
            return (Polygon)polygons.get(0);
        }
        return g2.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
    }
}

