/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;

public class EdgeEndBundle
extends EdgeEnd {
    private List edgeEnds = new ArrayList();

    public EdgeEndBundle(BoundaryNodeRule boundaryNodeRule, EdgeEnd e2) {
        super(e2.getEdge(), e2.getCoordinate(), e2.getDirectedCoordinate(), new Label(e2.getLabel()));
        this.insert(e2);
    }

    public EdgeEndBundle(EdgeEnd e2) {
        this(null, e2);
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    public Iterator iterator() {
        return this.edgeEnds.iterator();
    }

    public List getEdgeEnds() {
        return this.edgeEnds;
    }

    public void insert(EdgeEnd e2) {
        this.edgeEnds.add(e2);
    }

    @Override
    public void computeLabel(BoundaryNodeRule boundaryNodeRule) {
        boolean isArea = false;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it2.next();
            if (!e2.getLabel().isArea()) continue;
            isArea = true;
        }
        this.label = isArea ? new Label(-1, -1, -1) : new Label(-1);
        for (int i2 = 0; i2 < 2; ++i2) {
            this.computeLabelOn(i2, boundaryNodeRule);
            if (!isArea) continue;
            this.computeLabelSides(i2);
        }
    }

    private void computeLabelOn(int geomIndex, BoundaryNodeRule boundaryNodeRule) {
        int boundaryCount = 0;
        boolean foundInterior = false;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it2.next();
            int loc = e2.getLabel().getLocation(geomIndex);
            if (loc == 1) {
                ++boundaryCount;
            }
            if (loc != 0) continue;
            foundInterior = true;
        }
        int loc = -1;
        if (foundInterior) {
            loc = 0;
        }
        if (boundaryCount > 0) {
            loc = GeometryGraph.determineBoundary(boundaryNodeRule, boundaryCount);
        }
        this.label.setLocation(geomIndex, loc);
    }

    private void computeLabelSides(int geomIndex) {
        this.computeLabelSide(geomIndex, 1);
        this.computeLabelSide(geomIndex, 2);
    }

    private void computeLabelSide(int geomIndex, int side) {
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it2.next();
            if (!e2.getLabel().isArea()) continue;
            int loc = e2.getLabel().getLocation(geomIndex, side);
            if (loc == 0) {
                this.label.setLocation(geomIndex, side, 0);
                return;
            }
            if (loc != 2) continue;
            this.label.setLocation(geomIndex, side, 2);
        }
    }

    void updateIM(IntersectionMatrix im) {
        Edge.updateIM(this.label, im);
    }

    @Override
    public void print(PrintStream out) {
        out.println("EdgeEndBundle--> Label: " + this.label);
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd ee = (EdgeEnd)it2.next();
            ee.print(out);
            out.println();
        }
    }
}

