/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.locationtech.jts.geomgraph.Label;

public class EdgeEndBuilder {
    public List computeEdgeEnds(Iterator edges) {
        ArrayList l = new ArrayList();
        Iterator i2 = edges;
        while (i2.hasNext()) {
            Edge e2 = (Edge)i2.next();
            this.computeEdgeEnds(e2, l);
        }
        return l;
    }

    public void computeEdgeEnds(Edge edge, List l) {
        EdgeIntersectionList eiList = edge.getEdgeIntersectionList();
        eiList.addEndpoints();
        Iterator it2 = eiList.iterator();
        EdgeIntersection eiPrev = null;
        EdgeIntersection eiCurr = null;
        if (!it2.hasNext()) {
            return;
        }
        EdgeIntersection eiNext = (EdgeIntersection)it2.next();
        do {
            eiPrev = eiCurr;
            eiCurr = eiNext;
            eiNext = null;
            if (it2.hasNext()) {
                eiNext = (EdgeIntersection)it2.next();
            }
            if (eiCurr == null) continue;
            this.createEdgeEndForPrev(edge, l, eiCurr, eiPrev);
            this.createEdgeEndForNext(edge, l, eiCurr, eiNext);
        } while (eiCurr != null);
    }

    void createEdgeEndForPrev(Edge edge, List l, EdgeIntersection eiCurr, EdgeIntersection eiPrev) {
        int iPrev = eiCurr.segmentIndex;
        if (eiCurr.dist == 0.0) {
            if (iPrev == 0) {
                return;
            }
            --iPrev;
        }
        Coordinate pPrev = edge.getCoordinate(iPrev);
        if (eiPrev != null && eiPrev.segmentIndex >= iPrev) {
            pPrev = eiPrev.coord;
        }
        Label label2 = new Label(edge.getLabel());
        label2.flip();
        EdgeEnd e2 = new EdgeEnd(edge, eiCurr.coord, pPrev, label2);
        l.add(e2);
    }

    void createEdgeEndForNext(Edge edge, List l, EdgeIntersection eiCurr, EdgeIntersection eiNext) {
        int iNext = eiCurr.segmentIndex + 1;
        if (iNext >= edge.getNumPoints() && eiNext == null) {
            return;
        }
        Coordinate pNext = edge.getCoordinate(iNext);
        if (eiNext != null && eiNext.segmentIndex == eiCurr.segmentIndex) {
            pNext = eiNext.coord;
        }
        EdgeEnd e2 = new EdgeEnd(edge, eiCurr.coord, pNext, new Label(edge.getLabel()));
        l.add(e2);
    }
}

