/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.predicate.EnvelopeIntersectsVisitor;
import org.locationtech.jts.operation.predicate.GeometryContainsPointVisitor;
import org.locationtech.jts.operation.predicate.RectangleIntersectsSegmentVisitor;

public class RectangleIntersects {
    private Polygon rectangle;
    private Envelope rectEnv;

    public static boolean intersects(Polygon rectangle, Geometry b2) {
        RectangleIntersects rp = new RectangleIntersects(rectangle);
        return rp.intersects(b2);
    }

    public RectangleIntersects(Polygon rectangle) {
        this.rectangle = rectangle;
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean intersects(Geometry geom) {
        if (!this.rectEnv.intersects(geom.getEnvelopeInternal())) {
            return false;
        }
        EnvelopeIntersectsVisitor visitor2 = new EnvelopeIntersectsVisitor(this.rectEnv);
        visitor2.applyTo(geom);
        if (visitor2.intersects()) {
            return true;
        }
        GeometryContainsPointVisitor ecpVisitor = new GeometryContainsPointVisitor(this.rectangle);
        ecpVisitor.applyTo(geom);
        if (ecpVisitor.containsPoint()) {
            return true;
        }
        RectangleIntersectsSegmentVisitor riVisitor = new RectangleIntersectsSegmentVisitor(this.rectangle);
        riVisitor.applyTo(geom);
        return riVisitor.intersects();
    }
}

