/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.math.MathUtil;

class ElevationModel {
    private static final int DEFAULT_CELL_NUM = 3;
    private Envelope extent;
    private int numCellX;
    private int numCellY;
    private double cellSizeX;
    private double cellSizeY;
    private ElevationCell[][] cells;
    private boolean isInitialized = false;
    private boolean hasZValue = false;
    private double averageZ = Double.NaN;

    public static ElevationModel create(Geometry geom1, Geometry geom2) {
        Envelope extent = geom1.getEnvelopeInternal().copy();
        if (geom2 != null) {
            extent.expandToInclude(geom2.getEnvelopeInternal());
        }
        ElevationModel model2 = new ElevationModel(extent, 3, 3);
        if (geom1 != null) {
            model2.add(geom1);
        }
        if (geom2 != null) {
            model2.add(geom2);
        }
        return model2;
    }

    public ElevationModel(Envelope extent, int numCellX, int numCellY) {
        this.extent = extent;
        this.numCellX = numCellX;
        this.numCellY = numCellY;
        this.cellSizeX = extent.getWidth() / (double)numCellX;
        this.cellSizeY = extent.getHeight() / (double)numCellY;
        if (this.cellSizeX <= 0.0) {
            this.numCellX = 1;
        }
        if (this.cellSizeY <= 0.0) {
            this.numCellY = 1;
        }
        this.cells = new ElevationCell[numCellX][numCellY];
    }

    public void add(Geometry geom) {
        geom.apply(new CoordinateSequenceFilter(){
            private boolean hasZ = true;

            @Override
            public void filter(CoordinateSequence seq, int i2) {
                if (!seq.hasZ()) {
                    this.hasZ = false;
                    return;
                }
                double z = seq.getOrdinate(i2, 2);
                ElevationModel.this.add(seq.getOrdinate(i2, 0), seq.getOrdinate(i2, 1), z);
            }

            @Override
            public boolean isDone() {
                return !this.hasZ;
            }

            @Override
            public boolean isGeometryChanged() {
                return false;
            }
        });
    }

    protected void add(double x, double y, double z) {
        if (Double.isNaN(z)) {
            return;
        }
        this.hasZValue = true;
        ElevationCell cell = this.getCell(x, y, true);
        cell.add(z);
    }

    private void init() {
        this.isInitialized = true;
        int numCells = 0;
        double sumZ = 0.0;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            for (int j = 0; j < this.cells[0].length; ++j) {
                ElevationCell cell = this.cells[i2][j];
                if (cell == null) continue;
                cell.compute();
                ++numCells;
                sumZ += cell.getZ();
            }
        }
        this.averageZ = Double.NaN;
        if (numCells > 0) {
            this.averageZ = sumZ / (double)numCells;
        }
    }

    public double getZ(double x, double y) {
        ElevationCell cell;
        if (!this.isInitialized) {
            this.init();
        }
        if ((cell = this.getCell(x, y, false)) == null) {
            return this.averageZ;
        }
        return cell.getZ();
    }

    public void populateZ(Geometry geom) {
        if (!this.hasZValue) {
            return;
        }
        if (!this.isInitialized) {
            this.init();
        }
        geom.apply(new CoordinateSequenceFilter(){
            private boolean isDone = false;

            @Override
            public void filter(CoordinateSequence seq, int i2) {
                if (!seq.hasZ()) {
                    this.isDone = true;
                    return;
                }
                if (Double.isNaN(seq.getZ(i2))) {
                    double z = ElevationModel.this.getZ(seq.getOrdinate(i2, 0), seq.getOrdinate(i2, 1));
                    seq.setOrdinate(i2, 2, z);
                }
            }

            @Override
            public boolean isDone() {
                return this.isDone;
            }

            @Override
            public boolean isGeometryChanged() {
                return false;
            }
        });
    }

    private ElevationCell getCell(double x, double y, boolean isCreateIfMissing) {
        int ix = 0;
        if (this.numCellX > 1) {
            ix = (int)((x - this.extent.getMinX()) / this.cellSizeX);
            ix = MathUtil.clamp(ix, 0, this.numCellX - 1);
        }
        int iy = 0;
        if (this.numCellY > 1) {
            iy = (int)((y - this.extent.getMinY()) / this.cellSizeY);
            iy = MathUtil.clamp(iy, 0, this.numCellY - 1);
        }
        ElevationCell cell = this.cells[ix][iy];
        if (isCreateIfMissing && cell == null) {
            this.cells[ix][iy] = cell = new ElevationCell();
        }
        return cell;
    }

    static class ElevationCell {
        private int numZ = 0;
        private double sumZ = 0.0;
        private double avgZ;

        ElevationCell() {
        }

        public void add(double z) {
            ++this.numZ;
            this.sumZ += z;
        }

        public void compute() {
            this.avgZ = Double.NaN;
            if (this.numZ > 0) {
                this.avgZ = this.sumZ / (double)this.numZ;
            }
        }

        public double getZ() {
            return this.avgZ;
        }
    }
}

