/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.ValidatingNoder;
import org.locationtech.jts.noding.snapround.SnapRoundingNoder;
import org.locationtech.jts.operation.overlayng.Edge;
import org.locationtech.jts.operation.overlayng.EdgeMerger;
import org.locationtech.jts.operation.overlayng.EdgeSourceInfo;
import org.locationtech.jts.operation.overlayng.LineLimiter;
import org.locationtech.jts.operation.overlayng.OverlayUtil;
import org.locationtech.jts.operation.overlayng.RingClipper;

class EdgeNodingBuilder {
    private static final int MIN_LIMIT_PTS = 20;
    private static final boolean IS_NODING_VALIDATED = true;
    private PrecisionModel pm;
    List<NodedSegmentString> inputEdges = new ArrayList<NodedSegmentString>();
    private Noder customNoder;
    private Envelope clipEnv = null;
    private RingClipper clipper;
    private LineLimiter limiter;
    private boolean[] hasEdges = new boolean[2];

    private static Noder createFixedPrecisionNoder(PrecisionModel pm) {
        SnapRoundingNoder noder = new SnapRoundingNoder(pm);
        return noder;
    }

    private static Noder createFloatingPrecisionNoder(boolean doValidation) {
        MCIndexNoder mcNoder = new MCIndexNoder();
        RobustLineIntersector li = new RobustLineIntersector();
        mcNoder.setSegmentIntersector(new IntersectionAdder(li));
        Noder noder = mcNoder;
        if (doValidation) {
            noder = new ValidatingNoder(mcNoder);
        }
        return noder;
    }

    public EdgeNodingBuilder(PrecisionModel pm, Noder noder) {
        this.pm = pm;
        this.customNoder = noder;
    }

    private Noder getNoder() {
        if (this.customNoder != null) {
            return this.customNoder;
        }
        if (OverlayUtil.isFloating(this.pm)) {
            return EdgeNodingBuilder.createFloatingPrecisionNoder(true);
        }
        return EdgeNodingBuilder.createFixedPrecisionNoder(this.pm);
    }

    public void setClipEnvelope(Envelope clipEnv) {
        this.clipEnv = clipEnv;
        this.clipper = new RingClipper(clipEnv);
        this.limiter = new LineLimiter(clipEnv);
    }

    public boolean hasEdgesFor(int geomIndex) {
        return this.hasEdges[geomIndex];
    }

    public List<Edge> build(Geometry geom0, Geometry geom1) {
        this.add(geom0, 0);
        this.add(geom1, 1);
        List<Edge> nodedEdges = this.node(this.inputEdges);
        List<Edge> mergedEdges = EdgeMerger.merge(nodedEdges);
        return mergedEdges;
    }

    private List<Edge> node(List<NodedSegmentString> segStrings) {
        Noder noder = this.getNoder();
        noder.computeNodes(segStrings);
        Collection nodedSS = noder.getNodedSubstrings();
        List<Edge> edges = this.createEdges(nodedSS);
        return edges;
    }

    private List<Edge> createEdges(Collection<SegmentString> segStrings) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (SegmentString ss2 : segStrings) {
            Coordinate[] pts = ss2.getCoordinates();
            if (Edge.isCollapsed(pts)) continue;
            EdgeSourceInfo info2 = (EdgeSourceInfo)ss2.getData();
            this.hasEdges[info2.getIndex()] = true;
            edges.add(new Edge(ss2.getCoordinates(), info2));
        }
        return edges;
    }

    private void add(Geometry g2, int geomIndex) {
        if (g2 == null || g2.isEmpty()) {
            return;
        }
        if (this.isClippedCompletely(g2.getEnvelopeInternal())) {
            return;
        }
        if (g2 instanceof Polygon) {
            this.addPolygon((Polygon)g2, geomIndex);
        } else if (g2 instanceof LineString) {
            this.addLine((LineString)g2, geomIndex);
        } else if (g2 instanceof MultiLineString) {
            this.addCollection((MultiLineString)g2, geomIndex);
        } else if (g2 instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)g2, geomIndex);
        } else if (g2 instanceof GeometryCollection) {
            this.addGeometryCollection((GeometryCollection)g2, geomIndex, g2.getDimension());
        }
    }

    private void addCollection(GeometryCollection gc, int geomIndex) {
        for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
            Geometry g2 = gc.getGeometryN(i2);
            this.add(g2, geomIndex);
        }
    }

    private void addGeometryCollection(GeometryCollection gc, int geomIndex, int expectedDim) {
        for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
            Geometry g2 = gc.getGeometryN(i2);
            if (g2.getDimension() != expectedDim) {
                throw new IllegalArgumentException("Overlay input is mixed-dimension");
            }
            this.add(g2, geomIndex);
        }
    }

    private void addPolygon(Polygon poly, int geomIndex) {
        LinearRing shell = poly.getExteriorRing();
        this.addPolygonRing(shell, false, geomIndex);
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            LinearRing hole = poly.getInteriorRingN(i2);
            this.addPolygonRing(hole, true, geomIndex);
        }
    }

    private void addPolygonRing(LinearRing ring, boolean isHole, int index2) {
        if (ring.isEmpty()) {
            return;
        }
        if (this.isClippedCompletely(ring.getEnvelopeInternal())) {
            return;
        }
        Coordinate[] pts = this.clip(ring);
        if (pts.length < 2) {
            return;
        }
        int depthDelta = EdgeNodingBuilder.computeDepthDelta(ring, isHole);
        EdgeSourceInfo info2 = new EdgeSourceInfo(index2, depthDelta, isHole);
        this.addEdge(pts, info2);
    }

    private boolean isClippedCompletely(Envelope env) {
        if (this.clipEnv == null) {
            return false;
        }
        return this.clipEnv.disjoint(env);
    }

    private Coordinate[] clip(LinearRing ring) {
        Coordinate[] pts = ring.getCoordinates();
        Envelope env = ring.getEnvelopeInternal();
        if (this.clipper == null || this.clipEnv.covers(env)) {
            return EdgeNodingBuilder.removeRepeatedPoints(ring);
        }
        return this.clipper.clip(pts);
    }

    private static Coordinate[] removeRepeatedPoints(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        return CoordinateArrays.removeRepeatedPoints(pts);
    }

    private static int computeDepthDelta(LinearRing ring, boolean isHole) {
        boolean isCCW = Orientation.isCCW(ring.getCoordinateSequence());
        boolean isOriented = true;
        isOriented = !isHole ? !isCCW : isCCW;
        int depthDelta = isOriented ? 1 : -1;
        return depthDelta;
    }

    private void addLine(LineString line, int geomIndex) {
        if (line.isEmpty()) {
            return;
        }
        if (this.isClippedCompletely(line.getEnvelopeInternal())) {
            return;
        }
        if (this.isToBeLimited(line)) {
            List<Coordinate[]> sections = this.limit(line);
            for (Coordinate[] pts : sections) {
                this.addLine(pts, geomIndex);
            }
        } else {
            Coordinate[] ptsNoRepeat = EdgeNodingBuilder.removeRepeatedPoints(line);
            this.addLine(ptsNoRepeat, geomIndex);
        }
    }

    private void addLine(Coordinate[] pts, int geomIndex) {
        if (pts.length < 2) {
            return;
        }
        EdgeSourceInfo info2 = new EdgeSourceInfo(geomIndex);
        this.addEdge(pts, info2);
    }

    private void addEdge(Coordinate[] pts, EdgeSourceInfo info2) {
        NodedSegmentString ss2 = new NodedSegmentString(pts, info2);
        this.inputEdges.add(ss2);
    }

    private boolean isToBeLimited(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        if (this.limiter == null || pts.length <= 20) {
            return false;
        }
        Envelope env = line.getEnvelopeInternal();
        return !this.clipEnv.covers(env);
    }

    private List<Coordinate[]> limit(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        return this.limiter.limit(pts);
    }
}

