/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.validate;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Location;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.locationtech.jts.operation.overlay.validate.FuzzyPointLocator;
import org.locationtech.jts.operation.overlay.validate.OffsetPointGenerator;
import org.locationtech.jts.util.Debug;

public class OverlayResultValidator {
    private static final double TOLERANCE = 1.0E-6;
    private Geometry[] geom;
    private FuzzyPointLocator[] locFinder;
    private int[] location = new int[3];
    private Coordinate invalidLocation = null;
    private double boundaryDistanceTolerance = 1.0E-6;
    private List testCoords = new ArrayList();

    public static boolean isValid(Geometry a, Geometry b2, int overlayOp, Geometry result2) {
        OverlayResultValidator validator = new OverlayResultValidator(a, b2, result2);
        return validator.isValid(overlayOp);
    }

    private static double computeBoundaryDistanceTolerance(Geometry g0, Geometry g1) {
        return Math.min(GeometrySnapper.computeSizeBasedSnapTolerance(g0), GeometrySnapper.computeSizeBasedSnapTolerance(g1));
    }

    public OverlayResultValidator(Geometry a, Geometry b2, Geometry result2) {
        this.boundaryDistanceTolerance = OverlayResultValidator.computeBoundaryDistanceTolerance(a, b2);
        this.geom = new Geometry[]{a, b2, result2};
        this.locFinder = new FuzzyPointLocator[]{new FuzzyPointLocator(this.geom[0], this.boundaryDistanceTolerance), new FuzzyPointLocator(this.geom[1], this.boundaryDistanceTolerance), new FuzzyPointLocator(this.geom[2], this.boundaryDistanceTolerance)};
    }

    public boolean isValid(int overlayOp) {
        this.addTestPts(this.geom[0]);
        this.addTestPts(this.geom[1]);
        boolean isValid = this.checkValid(overlayOp);
        return isValid;
    }

    public Coordinate getInvalidLocation() {
        return this.invalidLocation;
    }

    private void addTestPts(Geometry g2) {
        OffsetPointGenerator ptGen = new OffsetPointGenerator(g2);
        this.testCoords.addAll(ptGen.getPoints(5.0 * this.boundaryDistanceTolerance));
    }

    private boolean checkValid(int overlayOp) {
        for (int i2 = 0; i2 < this.testCoords.size(); ++i2) {
            Coordinate pt = (Coordinate)this.testCoords.get(i2);
            if (this.checkValid(overlayOp, pt)) continue;
            this.invalidLocation = pt;
            return false;
        }
        return true;
    }

    private boolean checkValid(int overlayOp, Coordinate pt) {
        this.location[0] = this.locFinder[0].getLocation(pt);
        this.location[1] = this.locFinder[1].getLocation(pt);
        this.location[2] = this.locFinder[2].getLocation(pt);
        if (OverlayResultValidator.hasLocation(this.location, 1)) {
            return true;
        }
        return this.isValidResult(overlayOp, this.location);
    }

    private static boolean hasLocation(int[] location, int loc) {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (location[i2] != loc) continue;
            return true;
        }
        return false;
    }

    private boolean isValidResult(int overlayOp, int[] location) {
        boolean isValid;
        boolean expectedInterior = OverlayOp.isResultOfOp(location[0], location[1], overlayOp);
        boolean resultInInterior = location[2] == 0;
        boolean bl = isValid = !(expectedInterior ^ resultInInterior);
        if (!isValid) {
            this.reportResult(overlayOp, location, expectedInterior);
        }
        return isValid;
    }

    private void reportResult(int overlayOp, int[] location, boolean expectedInterior) {
        Debug.println("Overlay result invalid - A:" + Location.toLocationSymbol(location[0]) + " B:" + Location.toLocationSymbol(location[1]) + " expected:" + (expectedInterior ? (char)'i' : 'e') + " actual:" + Location.toLocationSymbol(location[2]));
    }
}

