/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.operation.overlay.OverlayOp;

public class PointBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private List resultPointList = new ArrayList();

    public PointBuilder(OverlayOp op, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op;
        this.geometryFactory = geometryFactory;
    }

    public List build(int opCode) {
        this.extractNonCoveredResultNodes(opCode);
        return this.resultPointList;
    }

    private void extractNonCoveredResultNodes(int opCode) {
        for (Node n : this.op.getGraph().getNodes()) {
            Label label2;
            if (n.isInResult() || n.isIncidentEdgeInResult() || n.getEdges().getDegree() != 0 && opCode != 1 || !OverlayOp.isResultOfOp(label2 = n.getLabel(), opCode)) continue;
            this.filterCoveredNodeToPoint(n);
        }
    }

    private void filterCoveredNodeToPoint(Node n) {
        Coordinate coord = n.getCoordinate();
        if (!this.op.isCoveredByLA(coord)) {
            Point pt = this.geometryFactory.createPoint(coord);
            this.resultPointList.add(pt);
        }
    }
}

