/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.operation.linemerge.LineMergeEdge;
import org.locationtech.jts.operation.linemerge.LineMergeGraph;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.Subgraph;
import org.locationtech.jts.planargraph.algorithm.ConnectedSubgraphFinder;
import org.locationtech.jts.util.Assert;

public class LineSequencer {
    private LineMergeGraph graph = new LineMergeGraph();
    private GeometryFactory factory = new GeometryFactory();
    private int lineCount = 0;
    private boolean isRun = false;
    private Geometry sequencedGeometry = null;
    private boolean isSequenceable = false;

    public static Geometry sequence(Geometry geom) {
        LineSequencer sequencer = new LineSequencer();
        sequencer.add(geom);
        return sequencer.getSequencedLineStrings();
    }

    public static boolean isSequenced(Geometry geom) {
        if (!(geom instanceof MultiLineString)) {
            return true;
        }
        MultiLineString mls = (MultiLineString)geom;
        TreeSet prevSubgraphNodes = new TreeSet();
        Coordinate lastNode = null;
        ArrayList<Coordinate> currNodes = new ArrayList<Coordinate>();
        for (int i2 = 0; i2 < mls.getNumGeometries(); ++i2) {
            LineString line = (LineString)mls.getGeometryN(i2);
            Coordinate startNode = line.getCoordinateN(0);
            Coordinate endNode = line.getCoordinateN(line.getNumPoints() - 1);
            if (prevSubgraphNodes.contains(startNode)) {
                return false;
            }
            if (prevSubgraphNodes.contains(endNode)) {
                return false;
            }
            if (lastNode != null && !startNode.equals(lastNode)) {
                prevSubgraphNodes.addAll(currNodes);
                currNodes.clear();
            }
            currNodes.add(startNode);
            currNodes.add(endNode);
            lastNode = endNode;
        }
        return true;
    }

    public void add(Collection geometries) {
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry component2) {
                if (component2 instanceof LineString) {
                    LineSequencer.this.addLine((LineString)component2);
                }
            }
        });
    }

    private void addLine(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
        ++this.lineCount;
    }

    public boolean isSequenceable() {
        this.computeSequence();
        return this.isSequenceable;
    }

    public Geometry getSequencedLineStrings() {
        this.computeSequence();
        return this.sequencedGeometry;
    }

    private void computeSequence() {
        if (this.isRun) {
            return;
        }
        this.isRun = true;
        List sequences = this.findSequences();
        if (sequences == null) {
            return;
        }
        this.sequencedGeometry = this.buildSequencedGeometry(sequences);
        this.isSequenceable = true;
        int finalLineCount = this.sequencedGeometry.getNumGeometries();
        Assert.isTrue(this.lineCount == finalLineCount, "Lines were missing from result");
        Assert.isTrue(this.sequencedGeometry instanceof LineString || this.sequencedGeometry instanceof MultiLineString, "Result is not lineal");
    }

    private List findSequences() {
        ArrayList<List> sequences = new ArrayList<List>();
        ConnectedSubgraphFinder csFinder = new ConnectedSubgraphFinder(this.graph);
        List subgraphs = csFinder.getConnectedSubgraphs();
        for (Subgraph subgraph : subgraphs) {
            if (this.hasSequence(subgraph)) {
                List seq = this.findSequence(subgraph);
                sequences.add(seq);
                continue;
            }
            return null;
        }
        return sequences;
    }

    private boolean hasSequence(Subgraph graph2) {
        int oddDegreeCount = 0;
        Iterator i2 = graph2.nodeIterator();
        while (i2.hasNext()) {
            Node node2 = (Node)i2.next();
            if (node2.getDegree() % 2 != 1) continue;
            ++oddDegreeCount;
        }
        return oddDegreeCount <= 2;
    }

    private List findSequence(Subgraph graph2) {
        GraphComponent.setVisited(graph2.edgeIterator(), false);
        Node startNode = LineSequencer.findLowestDegreeNode(graph2);
        DirectedEdge startDE = startNode.getOutEdges().iterator().next();
        DirectedEdge startDESym = startDE.getSym();
        LinkedList seq = new LinkedList();
        ListIterator lit = seq.listIterator();
        this.addReverseSubpath(startDESym, lit, false);
        while (lit.hasPrevious()) {
            DirectedEdge prev = (DirectedEdge)lit.previous();
            DirectedEdge unvisitedOutDE = LineSequencer.findUnvisitedBestOrientedDE(prev.getFromNode());
            if (unvisitedOutDE == null) continue;
            this.addReverseSubpath(unvisitedOutDE.getSym(), lit, true);
        }
        List orientedSeq = this.orient(seq);
        return orientedSeq;
    }

    private static DirectedEdge findUnvisitedBestOrientedDE(Node node2) {
        DirectedEdge wellOrientedDE = null;
        DirectedEdge unvisitedDE = null;
        Iterator<DirectedEdge> i2 = node2.getOutEdges().iterator();
        while (i2.hasNext()) {
            DirectedEdge de = i2.next();
            if (de.getEdge().isVisited()) continue;
            unvisitedDE = de;
            if (!de.getEdgeDirection()) continue;
            wellOrientedDE = de;
        }
        if (wellOrientedDE != null) {
            return wellOrientedDE;
        }
        return unvisitedDE;
    }

    private void addReverseSubpath(DirectedEdge de, ListIterator lit, boolean expectedClosed) {
        Node endNode = de.getToNode();
        Node fromNode = null;
        while (true) {
            lit.add(de.getSym());
            de.getEdge().setVisited(true);
            fromNode = de.getFromNode();
            DirectedEdge unvisitedOutDE = LineSequencer.findUnvisitedBestOrientedDE(fromNode);
            if (unvisitedOutDE == null) break;
            de = unvisitedOutDE.getSym();
        }
        if (expectedClosed) {
            Assert.isTrue(fromNode == endNode, "path not contiguous");
        }
    }

    private static Node findLowestDegreeNode(Subgraph graph2) {
        int minDegree = Integer.MAX_VALUE;
        Node minDegreeNode = null;
        Iterator i2 = graph2.nodeIterator();
        while (i2.hasNext()) {
            Node node2 = (Node)i2.next();
            if (minDegreeNode != null && node2.getDegree() >= minDegree) continue;
            minDegree = node2.getDegree();
            minDegreeNode = node2;
        }
        return minDegreeNode;
    }

    private List orient(List seq) {
        boolean hasDegree1Node;
        DirectedEdge startEdge = (DirectedEdge)seq.get(0);
        DirectedEdge endEdge = (DirectedEdge)seq.get(seq.size() - 1);
        Node startNode = startEdge.getFromNode();
        Node endNode = endEdge.getToNode();
        boolean flipSeq = false;
        boolean bl = hasDegree1Node = startNode.getDegree() == 1 || endNode.getDegree() == 1;
        if (hasDegree1Node) {
            boolean hasObviousStartNode = false;
            if (endEdge.getToNode().getDegree() == 1 && !endEdge.getEdgeDirection()) {
                hasObviousStartNode = true;
                flipSeq = true;
            }
            if (startEdge.getFromNode().getDegree() == 1 && startEdge.getEdgeDirection()) {
                hasObviousStartNode = true;
                flipSeq = false;
            }
            if (!hasObviousStartNode && startEdge.getFromNode().getDegree() == 1) {
                flipSeq = true;
            }
        }
        if (flipSeq) {
            return this.reverse(seq);
        }
        return seq;
    }

    private List reverse(List seq) {
        LinkedList<DirectedEdge> newSeq = new LinkedList<DirectedEdge>();
        for (DirectedEdge de : seq) {
            newSeq.addFirst(de.getSym());
        }
        return newSeq;
    }

    private Geometry buildSequencedGeometry(List sequences) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (List seq : sequences) {
            for (DirectedEdge de : seq) {
                LineString line;
                LineMergeEdge e2 = (LineMergeEdge)de.getEdge();
                LineString lineToAdd = line = e2.getLine();
                if (!de.getEdgeDirection() && !line.isClosed()) {
                    lineToAdd = LineSequencer.reverse(line);
                }
                lines.add(lineToAdd);
            }
        }
        if (lines.size() == 0) {
            return this.factory.createMultiLineString(new LineString[0]);
        }
        return this.factory.buildGeometry(lines);
    }

    private static LineString reverse(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        Coordinate[] revPts = new Coordinate[pts.length];
        int len = pts.length;
        for (int i2 = 0; i2 < len; ++i2) {
            revPts[len - 1 - i2] = new Coordinate(pts[i2]);
        }
        return line.getFactory().createLineString(revPts);
    }
}

