/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class GeometryLocation {
    public static final int INSIDE_AREA = -1;
    private Geometry component = null;
    private int segIndex;
    private Coordinate pt = null;

    public GeometryLocation(Geometry component2, int segIndex, Coordinate pt) {
        this.component = component2;
        this.segIndex = segIndex;
        this.pt = pt;
    }

    public GeometryLocation(Geometry component2, Coordinate pt) {
        this(component2, -1, pt);
    }

    public Geometry getGeometryComponent() {
        return this.component;
    }

    public int getSegmentIndex() {
        return this.segIndex;
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public boolean isInsideArea() {
        return this.segIndex == -1;
    }

    public String toString() {
        return this.component.getGeometryType() + "[" + this.segIndex + "]-" + WKTWriter.toPoint(this.pt);
    }
}

