/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentNode;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.util.Assert;

public class SegmentNodeList {
    private Map nodeMap = new TreeMap();
    private NodedSegmentString edge;

    public SegmentNodeList(NodedSegmentString edge) {
        this.edge = edge;
    }

    public NodedSegmentString getEdge() {
        return this.edge;
    }

    public SegmentNode add(Coordinate intPt, int segmentIndex) {
        SegmentNode eiNew = new SegmentNode(this.edge, intPt, segmentIndex, this.edge.getSegmentOctant(segmentIndex));
        SegmentNode ei = (SegmentNode)this.nodeMap.get(eiNew);
        if (ei != null) {
            Assert.isTrue(ei.coord.equals2D(intPt), "Found equal nodes with different coordinates");
            return ei;
        }
        this.nodeMap.put(eiNew, eiNew);
        return eiNew;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    private void addEndpoints() {
        int maxSegIndex = this.edge.size() - 1;
        this.add(this.edge.getCoordinate(0), 0);
        this.add(this.edge.getCoordinate(maxSegIndex), maxSegIndex);
    }

    private void addCollapsedNodes() {
        ArrayList collapsedVertexIndexes = new ArrayList();
        this.findCollapsesFromInsertedNodes(collapsedVertexIndexes);
        this.findCollapsesFromExistingVertices(collapsedVertexIndexes);
        Iterator it2 = collapsedVertexIndexes.iterator();
        while (it2.hasNext()) {
            int vertexIndex = (Integer)it2.next();
            this.add(this.edge.getCoordinate(vertexIndex), vertexIndex);
        }
    }

    private void findCollapsesFromExistingVertices(List collapsedVertexIndexes) {
        for (int i2 = 0; i2 < this.edge.size() - 2; ++i2) {
            Coordinate p0 = this.edge.getCoordinate(i2);
            Coordinate p1 = this.edge.getCoordinate(i2 + 1);
            Coordinate p2 = this.edge.getCoordinate(i2 + 2);
            if (!p0.equals2D(p2)) continue;
            collapsedVertexIndexes.add(i2 + 1);
        }
    }

    private void findCollapsesFromInsertedNodes(List collapsedVertexIndexes) {
        int[] collapsedVertexIndex = new int[1];
        Iterator it2 = this.iterator();
        SegmentNode eiPrev = (SegmentNode)it2.next();
        while (it2.hasNext()) {
            SegmentNode ei = (SegmentNode)it2.next();
            boolean isCollapsed = this.findCollapseIndex(eiPrev, ei, collapsedVertexIndex);
            if (isCollapsed) {
                collapsedVertexIndexes.add(collapsedVertexIndex[0]);
            }
            eiPrev = ei;
        }
    }

    private boolean findCollapseIndex(SegmentNode ei0, SegmentNode ei1, int[] collapsedVertexIndex) {
        if (!ei0.coord.equals2D(ei1.coord)) {
            return false;
        }
        int numVerticesBetween = ei1.segmentIndex - ei0.segmentIndex;
        if (!ei1.isInterior()) {
            --numVerticesBetween;
        }
        if (numVerticesBetween == 1) {
            collapsedVertexIndex[0] = ei0.segmentIndex + 1;
            return true;
        }
        return false;
    }

    public void addSplitEdges(Collection edgeList) {
        this.addEndpoints();
        this.addCollapsedNodes();
        Iterator it2 = this.iterator();
        SegmentNode eiPrev = (SegmentNode)it2.next();
        while (it2.hasNext()) {
            SegmentNode ei = (SegmentNode)it2.next();
            SegmentString newEdge = this.createSplitEdge(eiPrev, ei);
            edgeList.add(newEdge);
            eiPrev = ei;
        }
    }

    private void checkSplitEdgesCorrectness(List splitEdges) {
        Coordinate[] edgePts = this.edge.getCoordinates();
        SegmentString split0 = (SegmentString)splitEdges.get(0);
        Coordinate pt0 = split0.getCoordinate(0);
        if (!pt0.equals2D(edgePts[0])) {
            throw new RuntimeException("bad split edge start point at " + pt0);
        }
        SegmentString splitn = (SegmentString)splitEdges.get(splitEdges.size() - 1);
        Coordinate[] splitnPts = splitn.getCoordinates();
        Coordinate ptn = splitnPts[splitnPts.length - 1];
        if (!ptn.equals2D(edgePts[edgePts.length - 1])) {
            throw new RuntimeException("bad split edge end point at " + ptn);
        }
    }

    private SegmentString createSplitEdge(SegmentNode ei0, SegmentNode ei1) {
        Coordinate[] pts = this.createSplitEdgePts(ei0, ei1);
        return new NodedSegmentString(pts, this.edge.getData());
    }

    private Coordinate[] createSplitEdgePts(SegmentNode ei0, SegmentNode ei1) {
        boolean useIntPt1;
        int npts = ei1.segmentIndex - ei0.segmentIndex + 2;
        if (npts == 2) {
            return new Coordinate[]{new Coordinate(ei0.coord), new Coordinate(ei1.coord)};
        }
        Coordinate lastSegStartPt = this.edge.getCoordinate(ei1.segmentIndex);
        boolean bl = useIntPt1 = ei1.isInterior() || !ei1.coord.equals2D(lastSegStartPt);
        if (!useIntPt1) {
            --npts;
        }
        Coordinate[] pts = new Coordinate[npts];
        int ipt = 0;
        pts[ipt++] = new Coordinate(ei0.coord);
        for (int i2 = ei0.segmentIndex + 1; i2 <= ei1.segmentIndex; ++i2) {
            pts[ipt++] = this.edge.getCoordinate(i2);
        }
        if (useIntPt1) {
            pts[ipt] = new Coordinate(ei1.coord);
        }
        return pts;
    }

    public Coordinate[] getSplitCoordinates() {
        CoordinateList coordList = new CoordinateList();
        this.addEndpoints();
        Iterator it2 = this.iterator();
        SegmentNode eiPrev = (SegmentNode)it2.next();
        while (it2.hasNext()) {
            SegmentNode ei = (SegmentNode)it2.next();
            this.addEdgeCoordinates(eiPrev, ei, coordList);
            eiPrev = ei;
        }
        return coordList.toCoordinateArray();
    }

    private void addEdgeCoordinates(SegmentNode ei0, SegmentNode ei1, CoordinateList coordList) {
        Coordinate[] pts = this.createSplitEdgePts(ei0, ei1);
        coordList.add(pts, false);
    }

    public void print(PrintStream out) {
        out.println("Intersections:");
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            SegmentNode ei = (SegmentNode)it2.next();
            ei.print(out);
        }
    }
}

