/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Collection;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.noding.SegmentString;

public class NodingValidator {
    private LineIntersector li = new RobustLineIntersector();
    private Collection segStrings;
    private static final GeometryFactory fact = new GeometryFactory();

    public NodingValidator(Collection segStrings) {
        this.segStrings = segStrings;
    }

    public void checkValid() {
        this.checkEndPtVertexIntersections();
        this.checkInteriorIntersections();
        this.checkCollapses();
    }

    private void checkCollapses() {
        for (SegmentString ss2 : this.segStrings) {
            this.checkCollapses(ss2);
        }
    }

    private void checkCollapses(SegmentString ss2) {
        Coordinate[] pts = ss2.getCoordinates();
        for (int i2 = 0; i2 < pts.length - 2; ++i2) {
            this.checkCollapse(pts[i2], pts[i2 + 1], pts[i2 + 2]);
        }
    }

    private void checkCollapse(Coordinate p0, Coordinate p1, Coordinate p2) {
        if (p0.equals(p2)) {
            throw new RuntimeException("found non-noded collapse at " + fact.createLineString(new Coordinate[]{p0, p1, p2}));
        }
    }

    private void checkInteriorIntersections() {
        for (SegmentString ss0 : this.segStrings) {
            for (SegmentString ss1 : this.segStrings) {
                this.checkInteriorIntersections(ss0, ss1);
            }
        }
    }

    private void checkInteriorIntersections(SegmentString ss0, SegmentString ss1) {
        Coordinate[] pts0 = ss0.getCoordinates();
        Coordinate[] pts1 = ss1.getCoordinates();
        for (int i0 = 0; i0 < pts0.length - 1; ++i0) {
            for (int i1 = 0; i1 < pts1.length - 1; ++i1) {
                this.checkInteriorIntersections(ss0, i0, ss1, i1);
            }
        }
    }

    private void checkInteriorIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && (this.li.isProper() || this.hasInteriorIntersection(this.li, p00, p01) || this.hasInteriorIntersection(this.li, p10, p11))) {
            throw new RuntimeException("found non-noded intersection at " + p00 + "-" + p01 + " and " + p10 + "-" + p11);
        }
    }

    private boolean hasInteriorIntersection(LineIntersector li, Coordinate p0, Coordinate p1) {
        for (int i2 = 0; i2 < li.getIntersectionNum(); ++i2) {
            Coordinate intPt = li.getIntersection(i2);
            if (intPt.equals(p0) || intPt.equals(p1)) continue;
            return true;
        }
        return false;
    }

    private void checkEndPtVertexIntersections() {
        for (SegmentString ss2 : this.segStrings) {
            Coordinate[] pts = ss2.getCoordinates();
            this.checkEndPtVertexIntersections(pts[0], this.segStrings);
            this.checkEndPtVertexIntersections(pts[pts.length - 1], this.segStrings);
        }
    }

    private void checkEndPtVertexIntersections(Coordinate testPt, Collection segStrings) {
        for (SegmentString ss2 : segStrings) {
            Coordinate[] pts = ss2.getCoordinates();
            for (int j = 1; j < pts.length - 1; ++j) {
                if (!pts[j].equals(testPt)) continue;
                throw new RuntimeException("found endpt/interior pt intersection at index " + j + " :pt " + testPt);
            }
        }
    }
}

