/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import org.locationtech.jts.geom.Coordinate;

public class Vector3D {
    private double x;
    private double y;
    private double z;

    public static double dot(Coordinate A, Coordinate B, Coordinate C, Coordinate D) {
        double ABx = B.x - A.x;
        double ABy = B.y - A.y;
        double ABz = B.getZ() - A.getZ();
        double CDx = D.x - C.x;
        double CDy = D.y - C.y;
        double CDz = D.getZ() - C.getZ();
        return ABx * CDx + ABy * CDy + ABz * CDz;
    }

    public static Vector3D create(double x, double y, double z) {
        return new Vector3D(x, y, z);
    }

    public static Vector3D create(Coordinate coord) {
        return new Vector3D(coord);
    }

    public static double dot(Coordinate v1, Coordinate v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.getZ() * v2.getZ();
    }

    public Vector3D(Coordinate v2) {
        this.x = v2.x;
        this.y = v2.y;
        this.z = v2.getZ();
    }

    public Vector3D(Coordinate from, Coordinate to) {
        this.x = to.x - from.x;
        this.y = to.y - from.y;
        this.z = to.getZ() - from.getZ();
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3D add(Vector3D v2) {
        return Vector3D.create(this.x + v2.x, this.y + v2.y, this.z + v2.z);
    }

    public Vector3D subtract(Vector3D v2) {
        return Vector3D.create(this.x - v2.x, this.y - v2.y, this.z - v2.z);
    }

    public Vector3D divide(double d2) {
        return Vector3D.create(this.x / d2, this.y / d2, this.z / d2);
    }

    public double dot(Vector3D v2) {
        return this.x * v2.x + this.y * v2.y + this.z * v2.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(Coordinate v2) {
        return Math.sqrt(v2.x * v2.x + v2.y * v2.y + v2.getZ() * v2.getZ());
    }

    public Vector3D normalize() {
        double length = this.length();
        if (length > 0.0) {
            return this.divide(this.length());
        }
        return Vector3D.create(0.0, 0.0, 0.0);
    }

    public static Coordinate normalize(Coordinate v2) {
        double len = Vector3D.length(v2);
        return new Coordinate(v2.x / len, v2.y / len, v2.getZ() / len);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Vector3D)) {
            return false;
        }
        Vector3D v2 = (Vector3D)o2;
        return this.x == v2.x && this.y == v2.y && this.z == v2.z;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.hashCode(this.x);
        result2 = 37 * result2 + Coordinate.hashCode(this.y);
        result2 = 37 * result2 + Coordinate.hashCode(this.z);
        return result2;
    }
}

