/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.linearref.ExtractLineByLocation;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexOfLine;
import org.locationtech.jts.linearref.LocationIndexOfPoint;

public class LocationIndexedLine {
    private Geometry linearGeom;

    public LocationIndexedLine(Geometry linearGeom) {
        this.linearGeom = linearGeom;
        this.checkGeometryType();
    }

    private void checkGeometryType() {
        if (!(this.linearGeom instanceof LineString) && !(this.linearGeom instanceof MultiLineString)) {
            throw new IllegalArgumentException("Input geometry must be linear");
        }
    }

    public Coordinate extractPoint(LinearLocation index2) {
        return index2.getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(LinearLocation index2, double offsetDistance) {
        LinearLocation indexLow = index2.toLowest(this.linearGeom);
        return indexLow.getSegment(this.linearGeom).pointAlongOffset(indexLow.getSegmentFraction(), offsetDistance);
    }

    public Geometry extractLine(LinearLocation startIndex, LinearLocation endIndex) {
        return ExtractLineByLocation.extract(this.linearGeom, startIndex, endIndex);
    }

    public LinearLocation indexOf(Coordinate pt) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public LinearLocation indexOfAfter(Coordinate pt, LinearLocation minIndex) {
        return LocationIndexOfPoint.indexOfAfter(this.linearGeom, pt, minIndex);
    }

    public LinearLocation[] indicesOf(Geometry subLine) {
        return LocationIndexOfLine.indicesOf(this.linearGeom, subLine);
    }

    public LinearLocation project(Coordinate pt) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public LinearLocation getStartIndex() {
        return new LinearLocation();
    }

    public LinearLocation getEndIndex() {
        return LinearLocation.getEndLocation(this.linearGeom);
    }

    public boolean isValidIndex(LinearLocation index2) {
        return index2.isValid(this.linearGeom);
    }

    public LinearLocation clampIndex(LinearLocation index2) {
        LinearLocation loc = index2.copy();
        loc.clamp(this.linearGeom);
        return loc;
    }
}

