/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.linearref.LinearIterator;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.util.Assert;

class LocationIndexOfPoint {
    private Geometry linearGeom;

    public static LinearLocation indexOf(Geometry linearGeom, Coordinate inputPt) {
        LocationIndexOfPoint locater = new LocationIndexOfPoint(linearGeom);
        return locater.indexOf(inputPt);
    }

    public static LinearLocation indexOfAfter(Geometry linearGeom, Coordinate inputPt, LinearLocation minIndex) {
        LocationIndexOfPoint locater = new LocationIndexOfPoint(linearGeom);
        return locater.indexOfAfter(inputPt, minIndex);
    }

    public LocationIndexOfPoint(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public LinearLocation indexOf(Coordinate inputPt) {
        return this.indexOfFromStart(inputPt, null);
    }

    public LinearLocation indexOfAfter(Coordinate inputPt, LinearLocation minIndex) {
        if (minIndex == null) {
            return this.indexOf(inputPt);
        }
        LinearLocation endLoc = LinearLocation.getEndLocation(this.linearGeom);
        if (endLoc.compareTo(minIndex) <= 0) {
            return endLoc;
        }
        LinearLocation closestAfter = this.indexOfFromStart(inputPt, minIndex);
        Assert.isTrue(closestAfter.compareTo(minIndex) >= 0, "computed location is before specified minimum location");
        return closestAfter;
    }

    private LinearLocation indexOfFromStart(Coordinate inputPt, LinearLocation minIndex) {
        double minDistance = Double.MAX_VALUE;
        int minComponentIndex = 0;
        int minSegmentIndex = 0;
        double minFrac = -1.0;
        LineSegment seg = new LineSegment();
        LinearIterator it2 = new LinearIterator(this.linearGeom);
        while (it2.hasNext()) {
            if (!it2.isEndOfLine()) {
                seg.p0 = it2.getSegmentStart();
                seg.p1 = it2.getSegmentEnd();
                double segDistance = seg.distance(inputPt);
                double segFrac = seg.segmentFraction(inputPt);
                int candidateComponentIndex = it2.getComponentIndex();
                int candidateSegmentIndex = it2.getVertexIndex();
                if (segDistance < minDistance && (minIndex == null || minIndex.compareLocationValues(candidateComponentIndex, candidateSegmentIndex, segFrac) < 0)) {
                    minComponentIndex = candidateComponentIndex;
                    minSegmentIndex = candidateSegmentIndex;
                    minFrac = segFrac;
                    minDistance = segDistance;
                }
            }
            it2.next();
        }
        if (minDistance == Double.MAX_VALUE) {
            return new LinearLocation(minIndex);
        }
        LinearLocation loc = new LinearLocation(minComponentIndex, minSegmentIndex, minFrac);
        return loc;
    }
}

