/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.linearref.LinearIterator;
import org.locationtech.jts.linearref.LinearLocation;

public class LengthLocationMap {
    private final Geometry linearGeom;

    public static LinearLocation getLocation(Geometry linearGeom, double length) {
        LengthLocationMap locater = new LengthLocationMap(linearGeom);
        return locater.getLocation(length);
    }

    public static LinearLocation getLocation(Geometry linearGeom, double length, boolean resolveLower) {
        LengthLocationMap locater = new LengthLocationMap(linearGeom);
        return locater.getLocation(length, resolveLower);
    }

    public static double getLength(Geometry linearGeom, LinearLocation loc) {
        LengthLocationMap locater = new LengthLocationMap(linearGeom);
        return locater.getLength(loc);
    }

    public LengthLocationMap(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public LinearLocation getLocation(double length) {
        return this.getLocation(length, true);
    }

    public LinearLocation getLocation(double length, boolean resolveLower) {
        double forwardLength = length;
        if (length < 0.0) {
            double lineLen = this.linearGeom.getLength();
            forwardLength = lineLen + length;
        }
        LinearLocation loc = this.getLocationForward(forwardLength);
        if (resolveLower) {
            return loc;
        }
        return this.resolveHigher(loc);
    }

    private LinearLocation getLocationForward(double length) {
        if (length <= 0.0) {
            return new LinearLocation();
        }
        double totalLength = 0.0;
        LinearIterator it2 = new LinearIterator(this.linearGeom);
        while (it2.hasNext()) {
            if (it2.isEndOfLine()) {
                if (totalLength == length) {
                    int compIndex = it2.getComponentIndex();
                    int segIndex = it2.getVertexIndex();
                    return new LinearLocation(compIndex, segIndex, 0.0);
                }
            } else {
                Coordinate p0 = it2.getSegmentStart();
                Coordinate p1 = it2.getSegmentEnd();
                double segLen = p1.distance(p0);
                if (totalLength + segLen > length) {
                    double frac = (length - totalLength) / segLen;
                    int compIndex = it2.getComponentIndex();
                    int segIndex = it2.getVertexIndex();
                    return new LinearLocation(compIndex, segIndex, frac);
                }
                totalLength += segLen;
            }
            it2.next();
        }
        return LinearLocation.getEndLocation(this.linearGeom);
    }

    private LinearLocation resolveHigher(LinearLocation loc) {
        if (!loc.isEndpoint(this.linearGeom)) {
            return loc;
        }
        int compIndex = loc.getComponentIndex();
        if (compIndex >= this.linearGeom.getNumGeometries() - 1) {
            return loc;
        }
        while (++compIndex < this.linearGeom.getNumGeometries() - 1 && this.linearGeom.getGeometryN(compIndex).getLength() == 0.0) {
        }
        return new LinearLocation(compIndex, 0, 0.0);
    }

    public double getLength(LinearLocation loc) {
        double totalLength = 0.0;
        LinearIterator it2 = new LinearIterator(this.linearGeom);
        while (it2.hasNext()) {
            if (!it2.isEndOfLine()) {
                Coordinate p0 = it2.getSegmentStart();
                Coordinate p1 = it2.getSegmentEnd();
                double segLen = p1.distance(p0);
                if (loc.getComponentIndex() == it2.getComponentIndex() && loc.getSegmentIndex() == it2.getVertexIndex()) {
                    return totalLength + segLen * loc.getSegmentFraction();
                }
                totalLength += segLen;
            } else if (loc.getComponentIndex() == it2.getComponentIndex()) {
                return totalLength;
            }
            it2.next();
        }
        return totalLength;
    }
}

