/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.twkb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class Varint {
    private Varint() {
    }

    public static int zigZagEncode(int value2) {
        return value2 << 1 ^ value2 >> 31;
    }

    public static int zigzagDecode(int input) {
        int temp = (input << 31 >> 31 ^ input) >> 1;
        return temp ^ input & Integer.MIN_VALUE;
    }

    public static long zigZagEncode(long value2) {
        return value2 << 1 ^ value2 >> 63;
    }

    public static void writeSignedVarLong(long value2, DataOutput out) throws IOException {
        Varint.writeUnsignedVarLong(Varint.zigZagEncode(value2), out);
    }

    public static void writeUnsignedVarLong(long value2, DataOutput out) throws IOException {
        while ((value2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
        out.writeByte((int)value2 & 0x7F);
    }

    public static void writeSignedVarInt(int value2, DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(Varint.zigZagEncode(value2), out);
    }

    public static void writeUnsignedVarInt(int value2, DataOutput out) throws IOException {
        while ((long)(value2 & 0xFFFFFF80) != 0L) {
            out.writeByte(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
        out.writeByte(value2 & 0x7F);
    }

    public static long readSignedVarLong(DataInput in) throws IOException {
        long raw = Varint.readUnsignedVarLong(in);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(DataInput in) throws IOException {
        long b2;
        long value2 = 0L;
        int i2 = 0;
        while (((b2 = (long)in.readByte()) & 0x80L) != 0L) {
            value2 |= (b2 & 0x7FL) << i2;
            if ((i2 += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long (must be <= 63)");
        }
        return value2 | b2 << i2;
    }

    public static int readSignedVarInt(DataInput in) throws IOException {
        int raw = Varint.readUnsignedVarInt(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(DataInput in) throws IOException {
        byte b2;
        int value2 = 0;
        int i2 = 0;
        while (((b2 = in.readByte()) & 0x80) != 0) {
            value2 |= (b2 & 0x7F) << i2;
            if ((i2 += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long (must be <= 35)");
        }
        return value2 | b2 << i2;
    }

    public static int readUnsignedVarInt(byte[] from) throws IOException {
        byte b2;
        if (from.length < 5) {
            throw new IllegalArgumentException("buff should have at least 5 free slots to fit the biggest possible value representation");
        }
        int value2 = 0;
        int i2 = 0;
        int cnt = 0;
        while (((b2 = from[cnt]) & 0x80) != 0) {
            value2 |= (b2 & 0x7F) << i2;
            if ((i2 += 7) > 35) {
                throw new IllegalArgumentException("Variable length quantity is too long (must be <= 35)");
            }
            ++cnt;
        }
        return value2 | b2 << i2;
    }
}

