/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EnumSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.util.Assert;

public class WKTWriter {
    private static final int INDENT = 2;
    private static final int OUTPUT_DIMENSION = 2;
    private EnumSet<Ordinate> outputOrdinates;
    private final int outputDimension;
    private PrecisionModel precisionModel = null;
    private OrdinateFormat ordinateFormat = null;
    private boolean isFormatted = false;
    private int coordsPerLine = -1;
    private String indentTabStr;

    public static String toPoint(Coordinate p0) {
        return "POINT ( " + WKTWriter.format(p0) + " )";
    }

    public static String toLineString(CoordinateSequence seq) {
        StringBuilder buf = new StringBuilder();
        buf.append("LINESTRING");
        buf.append(" ");
        if (seq.size() == 0) {
            buf.append("EMPTY");
        } else {
            buf.append("(");
            for (int i2 = 0; i2 < seq.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                buf.append(WKTWriter.format(seq.getX(i2), seq.getY(i2)));
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String toLineString(Coordinate[] coord) {
        StringBuilder buf = new StringBuilder();
        buf.append("LINESTRING");
        buf.append(" ");
        if (coord.length == 0) {
            buf.append("EMPTY");
        } else {
            buf.append("(");
            for (int i2 = 0; i2 < coord.length; ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                buf.append(WKTWriter.format(coord[i2]));
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String toLineString(Coordinate p0, Coordinate p1) {
        return "LINESTRING ( " + WKTWriter.format(p0) + ", " + WKTWriter.format(p1) + " )";
    }

    public static String format(Coordinate p2) {
        return WKTWriter.format(p2.x, p2.y);
    }

    private static String format(double x, double y) {
        return OrdinateFormat.DEFAULT.format(x) + " " + OrdinateFormat.DEFAULT.format(y);
    }

    private static OrdinateFormat createFormatter(PrecisionModel precisionModel) {
        return OrdinateFormat.create(precisionModel.getMaximumSignificantDigits());
    }

    private static String stringOfChar(char ch, int count) {
        StringBuilder buf = new StringBuilder(count);
        for (int i2 = 0; i2 < count; ++i2) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public WKTWriter() {
        this(2);
    }

    public WKTWriter(int outputDimension) {
        this.setTab(2);
        this.outputDimension = outputDimension;
        if (outputDimension < 2 || outputDimension > 4) {
            throw new IllegalArgumentException("Invalid output dimension (must be 2 to 4)");
        }
        this.outputOrdinates = EnumSet.of(Ordinate.X, Ordinate.Y);
        if (outputDimension > 2) {
            this.outputOrdinates.add(Ordinate.Z);
        }
        if (outputDimension > 3) {
            this.outputOrdinates.add(Ordinate.M);
        }
    }

    public void setFormatted(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public void setMaxCoordinatesPerLine(int coordsPerLine) {
        this.coordsPerLine = coordsPerLine;
    }

    public void setTab(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Tab count must be positive");
        }
        this.indentTabStr = WKTWriter.stringOfChar(' ', size);
    }

    public void setOutputOrdinates(EnumSet<Ordinate> outputOrdinates) {
        this.outputOrdinates.remove((Object)Ordinate.Z);
        this.outputOrdinates.remove((Object)Ordinate.M);
        if (this.outputDimension == 3) {
            if (outputOrdinates.contains((Object)Ordinate.Z)) {
                this.outputOrdinates.add(Ordinate.Z);
            } else if (outputOrdinates.contains((Object)Ordinate.M)) {
                this.outputOrdinates.add(Ordinate.M);
            }
        }
        if (this.outputDimension == 4) {
            if (outputOrdinates.contains((Object)Ordinate.Z)) {
                this.outputOrdinates.add(Ordinate.Z);
            }
            if (outputOrdinates.contains((Object)Ordinate.M)) {
                this.outputOrdinates.add(Ordinate.M);
            }
        }
    }

    public EnumSet<Ordinate> getOutputOrdinates() {
        return this.outputOrdinates;
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
        this.ordinateFormat = OrdinateFormat.create(precisionModel.getMaximumSignificantDigits());
    }

    public String write(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, false, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, this.isFormatted, writer);
    }

    public String writeFormatted(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, true, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void writeFormatted(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, true, writer);
    }

    private void writeFormatted(Geometry geometry, boolean useFormatting, Writer writer) throws IOException {
        OrdinateFormat formatter = this.getFormatter(geometry);
        this.appendGeometryTaggedText(geometry, useFormatting, writer, formatter);
    }

    private OrdinateFormat getFormatter(Geometry geometry) {
        if (this.ordinateFormat != null) {
            return this.ordinateFormat;
        }
        PrecisionModel pm = geometry.getPrecisionModel();
        OrdinateFormat formatter = WKTWriter.createFormatter(pm);
        return formatter;
    }

    private void appendGeometryTaggedText(Geometry geometry, boolean useFormatting, Writer writer, OrdinateFormat formatter) throws IOException {
        CheckOrdinatesFilter cof = new CheckOrdinatesFilter(this.outputOrdinates);
        geometry.apply(cof);
        this.appendGeometryTaggedText(geometry, cof.getOutputOrdinates(), useFormatting, 0, writer, formatter);
    }

    private void appendGeometryTaggedText(Geometry geometry, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        this.indent(useFormatting, level, writer);
        if (geometry instanceof Point) {
            this.appendPointTaggedText((Point)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof LinearRing) {
            this.appendLinearRingTaggedText((LinearRing)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else {
            Assert.shouldNeverReachHere("Unsupported Geometry implementation:" + geometry.getClass());
        }
    }

    private void appendPointTaggedText(Point point, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("POINT");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(point.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private void appendLineStringTaggedText(LineString lineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("LINESTRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(lineString.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private void appendLinearRingTaggedText(LinearRing linearRing, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("LINEARRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(linearRing.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private void appendPolygonTaggedText(Polygon polygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("POLYGON");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendPolygonText(polygon, outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private void appendMultiPointTaggedText(MultiPoint multipoint, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("MULTIPOINT");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiPointText(multipoint, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("MULTILINESTRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiLineStringText(multiLineString, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("MULTIPOLYGON");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiPolygonText(multiPolygon, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("GEOMETRYCOLLECTION");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendGeometryCollectionText(geometryCollection, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private void appendCoordinate(CoordinateSequence seq, EnumSet<Ordinate> outputOrdinates, int i2, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write(WKTWriter.writeNumber(seq.getX(i2), formatter) + " " + WKTWriter.writeNumber(seq.getY(i2), formatter));
        if (outputOrdinates.contains((Object)Ordinate.Z)) {
            writer.write(" ");
            writer.write(WKTWriter.writeNumber(seq.getZ(i2), formatter));
        }
        if (outputOrdinates.contains((Object)Ordinate.M)) {
            writer.write(" ");
            writer.write(WKTWriter.writeNumber(seq.getM(i2), formatter));
        }
    }

    private static String writeNumber(double d2, OrdinateFormat formatter) {
        return formatter.format(d2);
    }

    private void appendOrdinateText(EnumSet<Ordinate> outputOrdinates, Writer writer) throws IOException {
        if (outputOrdinates.contains((Object)Ordinate.Z)) {
            writer.append("Z");
        }
        if (outputOrdinates.contains((Object)Ordinate.M)) {
            writer.append("M");
        }
    }

    private void appendSequenceText(CoordinateSequence seq, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, boolean indentFirst, Writer writer, OrdinateFormat formatter) throws IOException {
        if (seq.size() == 0) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(useFormatting, level, writer);
            }
            writer.write("(");
            for (int i2 = 0; i2 < seq.size(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i2 % this.coordsPerLine == 0) {
                        this.indent(useFormatting, level + 1, writer);
                    }
                }
                this.appendCoordinate(seq, outputOrdinates, i2, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendPolygonText(Polygon polygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, boolean indentFirst, Writer writer, OrdinateFormat formatter) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(useFormatting, level, writer);
            }
            writer.write("(");
            this.appendSequenceText(polygon.getExteriorRing().getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
            for (int i2 = 0; i2 < polygon.getNumInteriorRing(); ++i2) {
                writer.write(", ");
                this.appendSequenceText(polygon.getInteriorRingN(i2).getCoordinateSequence(), outputOrdinates, useFormatting, level + 1, true, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendMultiPointText(MultiPoint multiPoint, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiPoint.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i2 = 0; i2 < multiPoint.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    this.indentCoords(useFormatting, i2, level + 1, writer);
                }
                this.appendSequenceText(((Point)multiPoint.getGeometryN(i2)).getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendMultiLineStringText(MultiLineString multiLineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiLineString.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            for (int i2 = 0; i2 < multiLineString.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendSequenceText(((LineString)multiLineString.getGeometryN(i2)).getCoordinateSequence(), outputOrdinates, useFormatting, level2, doIndent, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendMultiPolygonText(MultiPolygon multiPolygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiPolygon.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            for (int i2 = 0; i2 < multiPolygon.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendPolygonText((Polygon)multiPolygon.getGeometryN(i2), outputOrdinates, useFormatting, level2, doIndent, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void appendGeometryCollectionText(GeometryCollection geometryCollection, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (geometryCollection.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            writer.write("(");
            for (int i2 = 0; i2 < geometryCollection.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getGeometryN(i2), outputOrdinates, useFormatting, level2, writer, formatter);
            }
            writer.write(")");
        }
    }

    private void indentCoords(boolean useFormatting, int coordIndex, int level, Writer writer) throws IOException {
        if (this.coordsPerLine <= 0 || coordIndex % this.coordsPerLine != 0) {
            return;
        }
        this.indent(useFormatting, level, writer);
    }

    private void indent(boolean useFormatting, int level, Writer writer) throws IOException {
        if (!useFormatting || level <= 0) {
            return;
        }
        writer.write("\n");
        for (int i2 = 0; i2 < level; ++i2) {
            writer.write(this.indentTabStr);
        }
    }

    private class CheckOrdinatesFilter
    implements CoordinateSequenceFilter {
        private final EnumSet<Ordinate> checkOrdinateFlags;
        private final EnumSet<Ordinate> outputOrdinates = EnumSet.of(Ordinate.X, Ordinate.Y);

        private CheckOrdinatesFilter(EnumSet<Ordinate> checkOrdinateFlags) {
            this.checkOrdinateFlags = checkOrdinateFlags;
        }

        @Override
        public void filter(CoordinateSequence seq, int i2) {
            if (this.checkOrdinateFlags.contains((Object)Ordinate.Z) && !this.outputOrdinates.contains((Object)Ordinate.Z) && !Double.isNaN(seq.getZ(i2))) {
                this.outputOrdinates.add(Ordinate.Z);
            }
            if (this.checkOrdinateFlags.contains((Object)Ordinate.M) && !this.outputOrdinates.contains((Object)Ordinate.M) && !Double.isNaN(seq.getM(i2))) {
                this.outputOrdinates.add(Ordinate.M);
            }
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.outputOrdinates.equals(this.checkOrdinateFlags);
        }

        EnumSet<Ordinate> getOutputOrdinates() {
            return this.outputOrdinates;
        }
    }
}

