/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.util.Assert;

public class WKBWriter {
    private int outputDimension = 2;
    private int byteOrder;
    private boolean includeSRID = false;
    private ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
    private OutStream byteArrayOutStream = new OutputStreamOutStream(this.byteArrayOS);
    private byte[] buf = new byte[8];

    public static String bytesToHex(byte[] bytes) {
        return WKBWriter.toHex(bytes);
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b2 = bytes[i2];
            buf.append(WKBWriter.toHexDigit(b2 >> 4 & 0xF));
            buf.append(WKBWriter.toHexDigit(b2 & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public WKBWriter() {
        this(2, 1);
    }

    public WKBWriter(int outputDimension) {
        this(outputDimension, 1);
    }

    public WKBWriter(int outputDimension, boolean includeSRID) {
        this(outputDimension, 1, includeSRID);
    }

    public WKBWriter(int outputDimension, int byteOrder) {
        this(outputDimension, byteOrder, false);
    }

    public WKBWriter(int outputDimension, int byteOrder, boolean includeSRID) {
        this.outputDimension = outputDimension;
        this.byteOrder = byteOrder;
        this.includeSRID = includeSRID;
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public byte[] write(Geometry geom) {
        try {
            this.byteArrayOS.reset();
            this.write(geom, this.byteArrayOutStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        return this.byteArrayOS.toByteArray();
    }

    public void write(Geometry geom, OutStream os) throws IOException {
        if (geom instanceof Point) {
            this.writePoint((Point)geom, os);
        } else if (geom instanceof LineString) {
            this.writeLineString((LineString)geom, os);
        } else if (geom instanceof Polygon) {
            this.writePolygon((Polygon)geom, os);
        } else if (geom instanceof MultiPoint) {
            this.writeGeometryCollection(4, (MultiPoint)geom, os);
        } else if (geom instanceof MultiLineString) {
            this.writeGeometryCollection(5, (MultiLineString)geom, os);
        } else if (geom instanceof MultiPolygon) {
            this.writeGeometryCollection(6, (MultiPolygon)geom, os);
        } else if (geom instanceof GeometryCollection) {
            this.writeGeometryCollection(7, (GeometryCollection)geom, os);
        } else {
            Assert.shouldNeverReachHere("Unknown Geometry type");
        }
    }

    private void writePoint(Point pt, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(1, pt, os);
        if (pt.getCoordinateSequence().size() == 0) {
            this.writeNaNs(this.outputDimension, os);
        } else {
            this.writeCoordinateSequence(pt.getCoordinateSequence(), false, os);
        }
    }

    private void writeLineString(LineString line, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(2, line, os);
        this.writeCoordinateSequence(line.getCoordinateSequence(), true, os);
    }

    private void writePolygon(Polygon poly, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(3, poly, os);
        if (poly.isEmpty()) {
            this.writeInt(0, os);
            return;
        }
        this.writeInt(poly.getNumInteriorRing() + 1, os);
        this.writeCoordinateSequence(poly.getExteriorRing().getCoordinateSequence(), true, os);
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            this.writeCoordinateSequence(poly.getInteriorRingN(i2).getCoordinateSequence(), true, os);
        }
    }

    private void writeGeometryCollection(int geometryType, GeometryCollection gc, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, gc, os);
        this.writeInt(gc.getNumGeometries(), os);
        boolean originalIncludeSRID = this.includeSRID;
        this.includeSRID = false;
        for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
            this.write(gc.getGeometryN(i2), os);
        }
        this.includeSRID = originalIncludeSRID;
    }

    private void writeByteOrder(OutStream os) throws IOException {
        this.buf[0] = this.byteOrder == 2 ? (byte)1 : 0;
        os.write(this.buf, 1);
    }

    private void writeGeometryType(int geometryType, Geometry g2, OutStream os) throws IOException {
        int flag3D = this.outputDimension == 3 ? Integer.MIN_VALUE : 0;
        int typeInt = geometryType | flag3D;
        this.writeInt(typeInt |= this.includeSRID ? 0x20000000 : 0, os);
        if (this.includeSRID) {
            this.writeInt(g2.getSRID(), os);
        }
    }

    private void writeInt(int intValue, OutStream os) throws IOException {
        ByteOrderValues.putInt(intValue, this.buf, this.byteOrder);
        os.write(this.buf, 4);
    }

    private void writeCoordinateSequence(CoordinateSequence seq, boolean writeSize, OutStream os) throws IOException {
        if (writeSize) {
            this.writeInt(seq.size(), os);
        }
        for (int i2 = 0; i2 < seq.size(); ++i2) {
            this.writeCoordinate(seq, i2, os);
        }
    }

    private void writeCoordinate(CoordinateSequence seq, int index2, OutStream os) throws IOException {
        ByteOrderValues.putDouble(seq.getX(index2), this.buf, this.byteOrder);
        os.write(this.buf, 8);
        ByteOrderValues.putDouble(seq.getY(index2), this.buf, this.byteOrder);
        os.write(this.buf, 8);
        if (this.outputDimension >= 3) {
            double ordVal = Double.NaN;
            if (seq.getDimension() >= 3) {
                ordVal = seq.getOrdinate(index2, 2);
            }
            ByteOrderValues.putDouble(ordVal, this.buf, this.byteOrder);
            os.write(this.buf, 8);
        }
    }

    private void writeNaNs(int numNaNs, OutStream os) throws IOException {
        for (int i2 = 0; i2 < numNaNs; ++i2) {
            ByteOrderValues.putDouble(Double.NaN, this.buf, this.byteOrder);
            os.write(this.buf, 8);
        }
    }
}

