/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.IntervalSize;
import org.locationtech.jts.index.quadtree.Node;
import org.locationtech.jts.index.quadtree.NodeBase;
import org.locationtech.jts.util.Assert;

public class Root
extends NodeBase {
    private static final Coordinate origin = new Coordinate(0.0, 0.0);

    public void insert(Envelope itemEnv, Object item) {
        int index2 = Root.getSubnodeIndex(itemEnv, Root.origin.x, Root.origin.y);
        if (index2 == -1) {
            this.add(item);
            return;
        }
        Node node2 = this.subnode[index2];
        if (node2 == null || !node2.getEnvelope().contains(itemEnv)) {
            Node largerNode;
            this.subnode[index2] = largerNode = Node.createExpanded(node2, itemEnv);
        }
        this.insertContained(this.subnode[index2], itemEnv, item);
    }

    private void insertContained(Node tree2, Envelope itemEnv, Object item) {
        Assert.isTrue(tree2.getEnvelope().contains(itemEnv));
        boolean isZeroX = IntervalSize.isZeroWidth(itemEnv.getMinX(), itemEnv.getMaxX());
        boolean isZeroY = IntervalSize.isZeroWidth(itemEnv.getMinY(), itemEnv.getMaxY());
        NodeBase node2 = isZeroX || isZeroY ? tree2.find(itemEnv) : tree2.getNode(itemEnv);
        node2.add(item);
    }

    @Override
    protected boolean isSearchMatch(Envelope searchEnv) {
        return true;
    }
}

