/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.Key;
import org.locationtech.jts.index.quadtree.NodeBase;
import org.locationtech.jts.util.Assert;

public class Node
extends NodeBase {
    private Envelope env;
    private double centrex;
    private double centrey;
    private int level;

    public static Node createNode(Envelope env) {
        Key key2 = new Key(env);
        Node node2 = new Node(key2.getEnvelope(), key2.getLevel());
        return node2;
    }

    public static Node createExpanded(Node node2, Envelope addEnv) {
        Envelope expandEnv = new Envelope(addEnv);
        if (node2 != null) {
            expandEnv.expandToInclude(node2.env);
        }
        Node largerNode = Node.createNode(expandEnv);
        if (node2 != null) {
            largerNode.insertNode(node2);
        }
        return largerNode;
    }

    public Node(Envelope env, int level) {
        this.env = env;
        this.level = level;
        this.centrex = (env.getMinX() + env.getMaxX()) / 2.0;
        this.centrey = (env.getMinY() + env.getMaxY()) / 2.0;
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    @Override
    protected boolean isSearchMatch(Envelope searchEnv) {
        if (searchEnv == null) {
            return false;
        }
        return this.env.intersects(searchEnv);
    }

    public Node getNode(Envelope searchEnv) {
        int subnodeIndex = Node.getSubnodeIndex(searchEnv, this.centrex, this.centrey);
        if (subnodeIndex != -1) {
            Node node2 = this.getSubnode(subnodeIndex);
            return node2.getNode(searchEnv);
        }
        return this;
    }

    public NodeBase find(Envelope searchEnv) {
        int subnodeIndex = Node.getSubnodeIndex(searchEnv, this.centrex, this.centrey);
        if (subnodeIndex == -1) {
            return this;
        }
        if (this.subnode[subnodeIndex] != null) {
            Node node2 = this.subnode[subnodeIndex];
            return node2.find(searchEnv);
        }
        return this;
    }

    void insertNode(Node node2) {
        Assert.isTrue(this.env == null || this.env.contains(node2.env));
        int index2 = Node.getSubnodeIndex(node2.env, this.centrex, this.centrey);
        if (node2.level == this.level - 1) {
            this.subnode[index2] = node2;
        } else {
            Node childNode = this.createSubnode(index2);
            childNode.insertNode(node2);
            this.subnode[index2] = childNode;
        }
    }

    private Node getSubnode(int index2) {
        if (this.subnode[index2] == null) {
            this.subnode[index2] = this.createSubnode(index2);
        }
        return this.subnode[index2];
    }

    private Node createSubnode(int index2) {
        double minx = 0.0;
        double maxx = 0.0;
        double miny = 0.0;
        double maxy = 0.0;
        switch (index2) {
            case 0: {
                minx = this.env.getMinX();
                maxx = this.centrex;
                miny = this.env.getMinY();
                maxy = this.centrey;
                break;
            }
            case 1: {
                minx = this.centrex;
                maxx = this.env.getMaxX();
                miny = this.env.getMinY();
                maxy = this.centrey;
                break;
            }
            case 2: {
                minx = this.env.getMinX();
                maxx = this.centrex;
                miny = this.centrey;
                maxy = this.env.getMaxY();
                break;
            }
            case 3: {
                minx = this.centrex;
                maxx = this.env.getMaxX();
                miny = this.centrey;
                maxy = this.env.getMaxY();
            }
        }
        Envelope sqEnv = new Envelope(minx, maxx, miny, maxy);
        Node node2 = new Node(sqEnv, this.level - 1);
        return node2;
    }

    int getLevel() {
        return this.level;
    }
}

