/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.chain;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.index.chain.MonotoneChain;

public class MonotoneChainBuilder {
    public static List getChains(Coordinate[] pts) {
        return MonotoneChainBuilder.getChains(pts, null);
    }

    public static List getChains(Coordinate[] pts, Object context) {
        int chainEnd;
        ArrayList<MonotoneChain> mcList = new ArrayList<MonotoneChain>();
        int chainStart = 0;
        do {
            chainEnd = MonotoneChainBuilder.findChainEnd(pts, chainStart);
            MonotoneChain mc = new MonotoneChain(pts, chainStart, chainEnd, context);
            mcList.add(mc);
        } while ((chainStart = chainEnd) < pts.length - 1);
        return mcList;
    }

    private static int findChainEnd(Coordinate[] pts, int start2) {
        int quad;
        int last2;
        int safeStart;
        for (safeStart = start2; safeStart < pts.length - 1 && pts[safeStart].equals2D(pts[safeStart + 1]); ++safeStart) {
        }
        if (safeStart >= pts.length - 1) {
            return pts.length - 1;
        }
        int chainQuad = Quadrant.quadrant(pts[safeStart], pts[safeStart + 1]);
        for (last2 = start2 + 1; last2 < pts.length && (pts[last2 - 1].equals2D(pts[last2]) || (quad = Quadrant.quadrant(pts[last2 - 1], pts[last2])) == chainQuad); ++last2) {
        }
        return last2 - 1;
    }
}

