/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.bintree.Node;
import org.locationtech.jts.index.bintree.NodeBase;
import org.locationtech.jts.index.quadtree.IntervalSize;
import org.locationtech.jts.util.Assert;

public class Root
extends NodeBase {
    private static final double origin = 0.0;

    public void insert(Interval itemInterval, Object item) {
        int index2 = Root.getSubnodeIndex(itemInterval, 0.0);
        if (index2 == -1) {
            this.add(item);
            return;
        }
        Node node2 = this.subnode[index2];
        if (node2 == null || !node2.getInterval().contains(itemInterval)) {
            Node largerNode;
            this.subnode[index2] = largerNode = Node.createExpanded(node2, itemInterval);
        }
        this.insertContained(this.subnode[index2], itemInterval, item);
    }

    private void insertContained(Node tree2, Interval itemInterval, Object item) {
        Assert.isTrue(tree2.getInterval().contains(itemInterval));
        boolean isZeroArea = IntervalSize.isZeroWidth(itemInterval.getMin(), itemInterval.getMax());
        NodeBase node2 = isZeroArea ? tree2.find(itemInterval) : tree2.getNode(itemInterval);
        node2.add(item);
    }

    @Override
    protected boolean isSearchMatch(Interval interval) {
        return true;
    }
}

