/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.bintree.Node;

public abstract class NodeBase {
    protected List items = new ArrayList();
    protected Node[] subnode = new Node[2];

    public static int getSubnodeIndex(Interval interval, double centre) {
        int subnodeIndex = -1;
        if (interval.min >= centre) {
            subnodeIndex = 1;
        }
        if (interval.max <= centre) {
            subnodeIndex = 0;
        }
        return subnodeIndex;
    }

    public List getItems() {
        return this.items;
    }

    public void add(Object item) {
        this.items.add(item);
    }

    public List addAllItems(List items2) {
        items2.addAll(this.items);
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.subnode[i2] == null) continue;
            this.subnode[i2].addAllItems(items2);
        }
        return items2;
    }

    protected abstract boolean isSearchMatch(Interval var1);

    public void addAllItemsFromOverlapping(Interval interval, Collection resultItems) {
        if (interval != null && !this.isSearchMatch(interval)) {
            return;
        }
        resultItems.addAll(this.items);
        if (this.subnode[0] != null) {
            this.subnode[0].addAllItemsFromOverlapping(interval, resultItems);
        }
        if (this.subnode[1] != null) {
            this.subnode[1].addAllItemsFromOverlapping(interval, resultItems);
        }
    }

    public boolean remove(Interval itemInterval, Object item) {
        if (!this.isSearchMatch(itemInterval)) {
            return false;
        }
        boolean found = false;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.subnode[i2] == null || !(found = this.subnode[i2].remove(itemInterval, item))) continue;
            if (!this.subnode[i2].isPrunable()) break;
            this.subnode[i2] = null;
            break;
        }
        if (found) {
            return found;
        }
        found = this.items.remove(item);
        return found;
    }

    public boolean isPrunable() {
        return !this.hasChildren() && !this.hasItems();
    }

    public boolean hasChildren() {
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.subnode[i2] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    int depth() {
        int maxSubDepth = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            int sqd;
            if (this.subnode[i2] == null || (sqd = this.subnode[i2].depth()) <= maxSubDepth) continue;
            maxSubDepth = sqd;
        }
        return maxSubDepth + 1;
    }

    int size() {
        int subSize = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.subnode[i2] == null) continue;
            subSize += this.subnode[i2].size();
        }
        return subSize + this.items.size();
    }

    int nodeSize() {
        int subSize = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.subnode[i2] == null) continue;
            subSize += this.subnode[i2].nodeSize();
        }
        return subSize + 1;
    }
}

