/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geomgraph.Depth;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.locationtech.jts.geomgraph.GraphComponent;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.index.MonotoneChainEdge;

public class Edge
extends GraphComponent {
    Coordinate[] pts;
    private Envelope env;
    EdgeIntersectionList eiList = new EdgeIntersectionList(this);
    private String name;
    private MonotoneChainEdge mce;
    private boolean isIsolated = true;
    private Depth depth = new Depth();
    private int depthDelta = 0;

    public static void updateIM(Label label2, IntersectionMatrix im) {
        im.setAtLeastIfValid(label2.getLocation(0, 0), label2.getLocation(1, 0), 1);
        if (label2.isArea()) {
            im.setAtLeastIfValid(label2.getLocation(0, 1), label2.getLocation(1, 1), 2);
            im.setAtLeastIfValid(label2.getLocation(0, 2), label2.getLocation(1, 2), 2);
        }
    }

    public Edge(Coordinate[] pts, Label label2) {
        this.pts = pts;
        this.label = label2;
    }

    public Edge(Coordinate[] pts) {
        this(pts, null);
    }

    public int getNumPoints() {
        return this.pts.length;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate getCoordinate(int i2) {
        return this.pts[i2];
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.pts.length > 0) {
            return this.pts[0];
        }
        return null;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            this.env = new Envelope();
            for (int i2 = 0; i2 < this.pts.length; ++i2) {
                this.env.expandToInclude(this.pts[i2]);
            }
        }
        return this.env;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public void setDepthDelta(int depthDelta) {
        this.depthDelta = depthDelta;
    }

    public int getMaximumSegmentIndex() {
        return this.pts.length - 1;
    }

    public EdgeIntersectionList getEdgeIntersectionList() {
        return this.eiList;
    }

    public MonotoneChainEdge getMonotoneChainEdge() {
        if (this.mce == null) {
            this.mce = new MonotoneChainEdge(this);
        }
        return this.mce;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public boolean isCollapsed() {
        if (!this.label.isArea()) {
            return false;
        }
        if (this.pts.length != 3) {
            return false;
        }
        return this.pts[0].equals(this.pts[2]);
    }

    public Edge getCollapsedEdge() {
        Coordinate[] newPts = new Coordinate[]{this.pts[0], this.pts[1]};
        Edge newe = new Edge(newPts, Label.toLineLabel(this.label));
        return newe;
    }

    public void setIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    @Override
    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void addIntersections(LineIntersector li, int segmentIndex, int geomIndex) {
        for (int i2 = 0; i2 < li.getIntersectionNum(); ++i2) {
            this.addIntersection(li, segmentIndex, geomIndex, i2);
        }
    }

    public void addIntersection(LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate nextPt;
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        int normalizedSegmentIndex = segmentIndex;
        double dist = li.getEdgeDistance(geomIndex, intIndex);
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
            dist = 0.0;
        }
        EdgeIntersection ei = this.eiList.add(intPt, normalizedSegmentIndex, dist);
    }

    @Override
    public void computeIM(IntersectionMatrix im) {
        Edge.updateIM(this.label, im);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Edge)) {
            return false;
        }
        Edge e2 = (Edge)o2;
        if (this.pts.length != e2.pts.length) {
            return false;
        }
        boolean isEqualForward = true;
        boolean isEqualReverse = true;
        int iRev = this.pts.length;
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (!this.pts[i2].equals2D(e2.pts[i2])) {
                isEqualForward = false;
            }
            if (!this.pts[i2].equals2D(e2.pts[--iRev])) {
                isEqualReverse = false;
            }
            if (isEqualForward || isEqualReverse) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.pts.length;
        if (this.pts.length > 0) {
            Coordinate p0 = this.pts[0];
            Coordinate p1 = this.pts[this.pts.length - 1];
            if (1 == p0.compareTo(p1)) {
                p0 = this.pts[this.pts.length - 1];
                p1 = this.pts[0];
            }
            result2 = 31 * result2 + p0.hashCode();
            result2 = 31 * result2 + p1.hashCode();
        }
        return result2;
    }

    public boolean isPointwiseEqual(Edge e2) {
        if (this.pts.length != e2.pts.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (this.pts[i2].equals2D(e2.pts[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("edge " + this.name + ": ");
        builder.append("LINESTRING (");
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (i2 > 0) {
                builder.append(",");
            }
            builder.append(this.pts[i2].x + " " + this.pts[i2].y);
        }
        builder.append(")  " + this.label + " " + this.depthDelta);
        return builder.toString();
    }

    public void print(PrintStream out) {
        out.print("edge " + this.name + ": ");
        out.print("LINESTRING (");
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (i2 > 0) {
                out.print(",");
            }
            out.print(this.pts[i2].x + " " + this.pts[i2].y);
        }
        out.print(")  " + this.label + " " + this.depthDelta);
    }

    public void printReverse(PrintStream out) {
        out.print("edge " + this.name + ": ");
        for (int i2 = this.pts.length - 1; i2 >= 0; --i2) {
            out.print(this.pts[i2] + " ");
        }
        out.println("");
    }
}

